/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.processor;

import io.lucenia.ml.common.processor.ModelExecutor;
import io.skylite.common.action.ActionListener;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.processor.InferenceProcessorAttributes;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.prediction.MLPredictionTaskAction;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLInferenceSearchRequestProcessor
extends AbstractProcessor
implements SearchRequestProcessor,
ModelExecutor {
    private final NamedXContentRegistry xContentRegistry;
    private static final Logger logger = LogManager.getLogger(MLInferenceSearchRequestProcessor.class);
    private final InferenceProcessorAttributes inferenceProcessorAttributes;
    private final boolean ignoreMissing;
    private final String functionName;
    private String queryTemplate;
    private final boolean fullResponsePath;
    private final boolean ignoreFailure;
    private final String modelInput;
    private final Client client;
    public static final String TYPE = "ml_inference";
    public static final String IGNORE_MISSING = "ignore_missing";
    public static final String QUERY_TEMPLATE = "query_template";
    public static final String FUNCTION_NAME = "function_name";
    public static final String FULL_RESPONSE_PATH = "full_response_path";
    public static final String MODEL_INPUT = "model_input";
    public static final String DEFAULT_MODEl_INPUT = "{ \"parameters\": ${ml_inference.parameters} }";
    public static final int DEFAULT_MAX_PREDICTION_TASKS = 10;

    protected MLInferenceSearchRequestProcessor(String modelId, String queryTemplate, List<Map<String, String>> inputMaps, List<Map<String, String>> outputMaps, Map<String, String> modelConfigMaps, int maxPredictionTask, String tag, String description, boolean ignoreMissing, String functionName, boolean fullResponsePath, boolean ignoreFailure, String modelInput, Client client, NamedXContentRegistry xContentRegistry) {
        super(tag, description, ignoreFailure);
        this.inferenceProcessorAttributes = new InferenceProcessorAttributes(modelId, inputMaps, outputMaps, modelConfigMaps, maxPredictionTask);
        this.ignoreMissing = ignoreMissing;
        this.functionName = functionName;
        this.fullResponsePath = fullResponsePath;
        this.queryTemplate = queryTemplate;
        this.ignoreFailure = ignoreFailure;
        this.modelInput = modelInput;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        throw new RuntimeException("ML inference search request processor make asynchronous calls and does not call processRequest");
    }

    public void processRequestAsync(SearchRequest request, ActionListener<SearchRequest> requestListener) {
        try {
            if (request.source() == null) {
                throw new IllegalArgumentException("query body is empty, cannot processor inference on empty query request.");
            }
            String queryString = request.source().toString();
            this.rewriteQueryString(request, queryString, requestListener);
        }
        catch (Exception e) {
            if (this.ignoreFailure) {
                requestListener.onResponse((Object)request);
            }
            requestListener.onFailure(e);
        }
    }

    private void rewriteQueryString(SearchRequest request, String queryString, ActionListener<SearchRequest> requestListener) throws IOException {
        int inputMapSize;
        List processInputMap = this.inferenceProcessorAttributes.getInputMaps();
        List processOutputMap = this.inferenceProcessorAttributes.getOutputMaps();
        int n = inputMapSize = processInputMap != null ? processInputMap.size() : 0;
        if (inputMapSize == 0) {
            requestListener.onResponse((Object)request);
            return;
        }
        try {
            if (!this.validateQueryFieldInQueryString(processInputMap, processOutputMap, queryString)) {
                requestListener.onResponse((Object)request);
            }
        }
        catch (Exception e) {
            if (this.ignoreMissing) {
                requestListener.onResponse((Object)request);
                return;
            }
            requestListener.onFailure(e);
            return;
        }
        ActionListener<Map<Integer, MLOutput>> rewriteRequestListener = this.createRewriteRequestListener(request, queryString, requestListener, processOutputMap);
        GroupedActionListener<Map<Integer, MLOutput>> batchPredictionListener = this.createBatchPredictionListener(rewriteRequestListener, inputMapSize);
        for (int inputMapIndex = 0; inputMapIndex < inputMapSize; ++inputMapIndex) {
            this.processPredictions(queryString, processInputMap, inputMapIndex, batchPredictionListener);
        }
    }

    private ActionListener<Map<Integer, MLOutput>> createRewriteRequestListener(final SearchRequest request, final String queryString, final ActionListener<SearchRequest> requestListener, final List<Map<String, String>> processOutputMap) {
        return new ActionListener<Map<Integer, MLOutput>>(){

            public void onResponse(Map<Integer, MLOutput> multipleMLOutputs) {
                for (Map.Entry<Integer, MLOutput> entry : multipleMLOutputs.entrySet()) {
                    Integer mappingIndex = entry.getKey();
                    MLOutput mlOutput = entry.getValue();
                    Map outputMapping = (Map)processOutputMap.get(mappingIndex);
                    try {
                        SearchSourceBuilder searchSourceBuilder;
                        if (MLInferenceSearchRequestProcessor.this.queryTemplate == null) {
                            Map incomeQueryObject = (Map)Strings.fromJson((String)queryString, Map.class);
                            this.updateIncomeQueryObject(incomeQueryObject, outputMapping, mlOutput);
                            searchSourceBuilder = MLInferenceSearchRequestProcessor.getSearchSourceBuilder(MLInferenceSearchRequestProcessor.this.xContentRegistry, Strings.toJson((Object)incomeQueryObject));
                            request.source(searchSourceBuilder);
                            requestListener.onResponse((Object)request);
                            continue;
                        }
                        String newQueryString = this.updateQueryTemplate(MLInferenceSearchRequestProcessor.this.queryTemplate, outputMapping, mlOutput);
                        searchSourceBuilder = MLInferenceSearchRequestProcessor.getSearchSourceBuilder(MLInferenceSearchRequestProcessor.this.xContentRegistry, newQueryString);
                        request.source(searchSourceBuilder);
                        requestListener.onResponse((Object)request);
                    }
                    catch (Exception e) {
                        if (MLInferenceSearchRequestProcessor.this.ignoreFailure) {
                            logger.error("Failed in writing prediction outcomes to new query", (Throwable)e);
                            requestListener.onResponse((Object)request);
                            continue;
                        }
                        requestListener.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                if (MLInferenceSearchRequestProcessor.this.ignoreFailure) {
                    logger.error("Failed in writing prediction outcomes to new query", (Throwable)e);
                    requestListener.onResponse((Object)request);
                } else {
                    requestListener.onFailure(e);
                }
            }

            private void updateIncomeQueryObject(Object incomeQueryObject, Map<String, String> outputMapping, MLOutput mlOutput) {
                for (Map.Entry<String, String> outputMapEntry : outputMapping.entrySet()) {
                    String newQueryField = outputMapEntry.getKey();
                    try {
                        String modelOutputFieldName = outputMapEntry.getValue();
                        Object modelOutputValue = MLInferenceSearchRequestProcessor.this.getModelOutputValue(mlOutput, modelOutputFieldName, MLInferenceSearchRequestProcessor.this.ignoreMissing, MLInferenceSearchRequestProcessor.this.fullResponsePath);
                        if (newQueryField.startsWith("$.ext.") || newQueryField.startsWith("ext.")) {
                            incomeQueryObject = Strings.prepareNestedStructures((Object)incomeQueryObject, (String)newQueryField);
                        }
                        if (!Strings.pathExists((Object)incomeQueryObject, (String)newQueryField)) continue;
                        Strings.setJsonPathValue((Object)incomeQueryObject, (String)newQueryField, (Object)modelOutputValue);
                    }
                    catch (Exception e) {
                        logger.error("Failed to set {} in query string: {}", (Object)newQueryField, (Object)e.getMessage());
                        throw new IllegalArgumentException("can not find path " + newQueryField + " in query string");
                    }
                }
            }

            private String updateQueryTemplate(String queryTemplate, Map<String, String> outputMapping, MLOutput mlOutput) {
                HashMap<String, Object> valuesMap = new HashMap<String, Object>();
                for (Map.Entry<String, String> outputMapEntry : outputMapping.entrySet()) {
                    String newQueryField = outputMapEntry.getKey();
                    String modelOutputFieldName = outputMapEntry.getValue();
                    Object modelOutputValue = MLInferenceSearchRequestProcessor.this.getModelOutputValue(mlOutput, modelOutputFieldName, MLInferenceSearchRequestProcessor.this.ignoreMissing, MLInferenceSearchRequestProcessor.this.fullResponsePath);
                    valuesMap.put(newQueryField, modelOutputValue);
                }
                StringSubstitutor sub = new StringSubstitutor(valuesMap);
                return sub.replace(queryTemplate);
            }
        };
    }

    private GroupedActionListener<Map<Integer, MLOutput>> createBatchPredictionListener(final ActionListener<Map<Integer, MLOutput>> rewriteRequestListener, int inputMapSize) {
        return new GroupedActionListener((ActionListener)new ActionListener<Collection<Map<Integer, MLOutput>>>(this){

            public void onResponse(Collection<Map<Integer, MLOutput>> mlOutputMapCollection) {
                HashMap<Integer, MLOutput> mlOutputMaps = new HashMap<Integer, MLOutput>();
                for (Map<Integer, MLOutput> mlOutputMap : mlOutputMapCollection) {
                    mlOutputMaps.putAll(mlOutputMap);
                }
                rewriteRequestListener.onResponse(mlOutputMaps);
            }

            public void onFailure(Exception e) {
                logger.error("Prediction Failed:", (Throwable)e);
                rewriteRequestListener.onFailure(e);
            }
        }, Math.max(inputMapSize, 1));
    }

    private boolean validateQueryFieldInQueryString(List<Map<String, String>> processInputMap, List<Map<String, String>> processOutputMap, String queryString) {
        String queryField;
        Map jsonData = (Map)Strings.fromJson((String)queryString, Map.class);
        for (Map<String, String> inputMap : processInputMap) {
            for (Map.Entry<String, String> entry : inputMap.entrySet()) {
                queryField = entry.getValue();
                if (Strings.pathExists((Object)jsonData, (String)queryField)) continue;
                throw new IllegalArgumentException("cannot find field: " + queryField + " in query string: " + queryString);
            }
        }
        if (this.queryTemplate == null) {
            for (Map<String, String> outputMap : processOutputMap) {
                for (Map.Entry<String, String> entry : outputMap.entrySet()) {
                    queryField = entry.getKey();
                    if (!queryField.startsWith("query.") && !queryField.startsWith("$.query.") || Strings.pathExists((Object)jsonData, (String)queryField)) continue;
                    throw new IllegalArgumentException("cannot find field: " + queryField + " in query string: " + queryString);
                }
            }
        }
        return true;
    }

    private void processPredictions(String queryString, List<Map<String, String>> processInputMap, final int inputMapIndex, final GroupedActionListener batchPredictionListener) throws IOException {
        HashMap<String, String> modelParameters = new HashMap<String, String>();
        HashMap modelConfigs = new HashMap();
        if (this.inferenceProcessorAttributes.getModelConfigMaps() != null) {
            modelParameters.putAll(this.inferenceProcessorAttributes.getModelConfigMaps());
            modelConfigs.putAll(this.inferenceProcessorAttributes.getModelConfigMaps());
        }
        Map<Object, Object> inputMapping = new HashMap();
        if (processInputMap != null) {
            inputMapping = processInputMap.get(inputMapIndex);
            Map newQuery = (Map)Strings.fromJson((String)queryString, Map.class);
            for (Map.Entry<Object, Object> entry : inputMapping.entrySet()) {
                String modelInputFieldName = (String)entry.getKey();
                String queryFieldName = (String)entry.getValue();
                Object queryFieldValue = Strings.readJsonPathField((Object)newQuery, (String)queryFieldName);
                modelParameters.put(modelInputFieldName, Strings.toJson((Object)queryFieldValue));
            }
        }
        HashSet inputMapKeys = new HashSet(modelParameters.keySet());
        inputMapKeys.removeAll(modelConfigs.keySet());
        HashMap<String, String> inputMappings = new HashMap<String, String>();
        for (String k : inputMapKeys) {
            inputMappings.put(k, (String)modelParameters.get(k));
        }
        ActionRequest actionRequest = this.getMLModelInferenceRequest(this.xContentRegistry, modelParameters, modelConfigs, inputMappings, this.inferenceProcessorAttributes.getModelId(), this.functionName, this.modelInput);
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, actionRequest, (ActionListener)new ActionListener<MLTaskResponse>(this){

            public void onResponse(MLTaskResponse mlTaskResponse) {
                MLOutput mlOutput = mlTaskResponse.getOutput();
                HashMap<Integer, MLOutput> mlOutputMap = new HashMap<Integer, MLOutput>();
                mlOutputMap.put(inputMapIndex, mlOutput);
                batchPredictionListener.onResponse(mlOutputMap);
            }

            public void onFailure(Exception e) {
                batchPredictionListener.onFailure(e);
            }
        });
    }

    private static SearchSourceBuilder getSearchSourceBuilder(NamedXContentRegistry xContentRegistry, String queryString) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryString);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)queryParser.nextToken(), (XContentParser)queryParser);
        searchSourceBuilder.parseXContent(queryParser);
        return searchSourceBuilder;
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements SearchProcessor.Factory<MLInferenceSearchRequestProcessor> {
        private final Client client;
        private final NamedXContentRegistry xContentRegistry;

        public Factory(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public MLInferenceSearchRequestProcessor create(Map<String, SearchProcessor.Factory<MLInferenceSearchRequestProcessor>> processorFactories, String processorTag, String description, boolean ignoreFailure, Map<String, Object> config, SearchProcessor.PipelineContext pipelineContext) {
            String modelId = ConfigurationUtils.readStringProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"model_id");
            String queryTemplate = ConfigurationUtils.readOptionalStringProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchRequestProcessor.QUERY_TEMPLATE);
            Map modelConfigInput = ConfigurationUtils.readOptionalMap((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"model_config");
            List inputMaps = ConfigurationUtils.readList((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"input_map");
            List outputMaps = ConfigurationUtils.readList((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"output_map");
            int maxPredictionTask = ConfigurationUtils.readIntProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"max_prediction_tasks", (Integer)10);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchRequestProcessor.IGNORE_MISSING, (boolean)false);
            String functionName = ConfigurationUtils.readStringProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchRequestProcessor.FUNCTION_NAME, (String)FunctionName.REMOTE.name());
            String modelInput = ConfigurationUtils.readOptionalStringProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchRequestProcessor.MODEL_INPUT);
            if (functionName.equalsIgnoreCase("remote")) {
                modelInput = modelInput != null ? modelInput : MLInferenceSearchRequestProcessor.DEFAULT_MODEl_INPUT;
            } else if (modelInput == null) {
                throw new IllegalArgumentException("Please provide model input when using a local model in ML Inference Processor");
            }
            boolean defaultFullResponsePath = !functionName.equalsIgnoreCase(FunctionName.REMOTE.name());
            boolean fullResponsePath = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchRequestProcessor.FULL_RESPONSE_PATH, (boolean)defaultFullResponsePath);
            ignoreFailure = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchRequestProcessor.TYPE, (String)processorTag, config, (String)"ignore_failure", (boolean)false);
            Map modelConfigMaps = null;
            if (modelConfigInput != null) {
                modelConfigMaps = Strings.getParameterMap((Map)modelConfigInput);
            }
            if (inputMaps != null && inputMaps.size() > maxPredictionTask) {
                throw new IllegalArgumentException("The number of prediction task setting in this process is " + inputMaps.size() + ". It exceeds the max_prediction_tasks of " + maxPredictionTask + ". Please reduce the size of input_map or increase max_prediction_tasks.");
            }
            return new MLInferenceSearchRequestProcessor(modelId, queryTemplate, inputMaps, outputMaps, modelConfigMaps, maxPredictionTask, processorTag, description, ignoreMissing, functionName, fullResponsePath, ignoreFailure, modelInput, this.client, this.xContentRegistry);
        }
    }
}

