/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.lucenia.ml.common.remote.AbstractConnectorExecutor;
import io.lucenia.ml.common.remote.HttpStreamingAsyncEntityProducer;
import io.lucenia.ml.common.remote.MLHttp5AsyncResponseConsumer;
import io.lucenia.ml.common.remote.MLHttpClientFactory;
import io.lucenia.ml.common.remote.MLSdkAsyncHttpResponseHandler;
import io.skylite.common.TokenBucket;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.script.ScriptService;
import io.skylite.ml.common.annotation.ConnectorExecutor;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.HttpConnector;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.ExecutionContext;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ConnectorExecutor(value="http")
public class HttpJsonConnectorExecutor
extends AbstractConnectorExecutor {
    private static final Logger log = LogManager.getLogger(HttpJsonConnectorExecutor.class);
    private HttpConnector connector;
    private ScriptService scriptService;
    private TokenBucket rateLimiter;
    private Map<String, TokenBucket> userRateLimiterMap;
    private MLGuard mlGuard;
    private volatile AtomicBoolean connectorPrivateIpEnabled;
    private CloseableHttpAsyncClient httpClient;
    private ReleasableSkyliteClient client;

    public HttpJsonConnectorExecutor(HttpConnector connector) {
        super.initialize((Connector)connector);
        this.connector = connector;
        Duration connectionTimeout = Duration.ofSeconds(super.getConnectorClientConfig().getConnectionTimeout());
        Duration readTimeout = Duration.ofSeconds(super.getConnectorClientConfig().getReadTimeout());
        Integer maxConnection = super.getConnectorClientConfig().getMaxConnections();
        Double maxConnectionsPerRouteAsPercent = super.getConnectorClientConfig().getMaxConnectionsPerRouteAsPercent();
        this.httpClient = MLHttpClientFactory.getAsyncHttpClient(connectionTimeout, readTimeout, maxConnection, maxConnectionsPerRouteAsPercent);
        this.httpClient.start();
    }

    public HttpConnector getConnector() {
        return this.connector;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public TokenBucket getRateLimiter() {
        return this.rateLimiter;
    }

    public Map<String, TokenBucket> getUserRateLimiterMap() {
        return this.userRateLimiterMap;
    }

    public MLGuard getMlGuard() {
        return this.mlGuard;
    }

    public Logger getLogger() {
        return log;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public void setRateLimiter(TokenBucket rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public void setUserRateLimiterMap(Map<String, TokenBucket> userRateLimiterMap) {
        this.userRateLimiterMap = userRateLimiterMap;
    }

    public void setMlGuard(MLGuard mlGuard) {
        this.mlGuard = mlGuard;
    }

    public void setConnectorPrivateIpEnabled(AtomicBoolean connectorPrivateIpEnabled) {
        this.connectorPrivateIpEnabled = connectorPrivateIpEnabled;
    }

    public void invokeRemoteService(String action, MLInput mlInput, Map<String, String> parameters, String payload, ExecutionContext executionContext, final ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        try {
            AsyncRequestProducer requestProducer = this.convertToAsyncRequestProducer(switch (this.connector.getActionHttpMethod(action).toUpperCase(Locale.ROOT)) {
                case "POST" -> {
                    log.debug("original payload to remote model: " + payload);
                    this.validateHttpClientParameters(action, parameters);
                    yield this.connector.buildSdkRequest(action, parameters, payload, RestRequest.Method.POST);
                }
                case "GET" -> {
                    this.validateHttpClientParameters(action, parameters);
                    yield this.connector.buildSdkRequest(action, parameters, null, RestRequest.Method.GET);
                }
                default -> throw new IllegalArgumentException("unsupported http method");
            });
            MLSdkAsyncHttpResponseHandler awsResponseHandler = new MLSdkAsyncHttpResponseHandler(executionContext, actionListener, parameters, (Connector)this.connector, this.scriptService, this.mlGuard, action);
            MLHttp5AsyncResponseConsumer responseConsumer = new MLHttp5AsyncResponseConsumer(awsResponseHandler);
            AccessController.doPrivileged(() -> {
                final CompletableFuture future = new CompletableFuture();
                this.httpClient.execute(requestProducer, responseConsumer, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                    public void completed(SimpleHttpResponse response) {
                        log.debug("HTTP request completed with status: {}", (Object)response.getCode());
                    }

                    public void failed(Exception ex) {
                        log.error("HTTP request failed", (Throwable)ex);
                        actionListener.onFailure(ex);
                        future.completeExceptionally(ex);
                    }

                    public void cancelled() {
                        log.warn("HTTP request was cancelled");
                        actionListener.onFailure((Exception)new RuntimeException("Request was cancelled"));
                        future.completeExceptionally(new RuntimeException("Request was cancelled"));
                    }
                });
                return null;
            });
        }
        catch (RuntimeException e) {
            log.error("Fail to execute http connector", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
        catch (Throwable e) {
            log.error("Fail to execute http connector", e);
            actionListener.onFailure((Exception)new MLException("Fail to execute http connector", e));
        }
    }

    private AsyncRequestProducer convertToAsyncRequestProducer(ClassicHttpRequest classicRequest) throws IOException, URISyntaxException {
        BasicHttpRequest asyncRequest = new BasicHttpRequest(classicRequest.getMethod(), classicRequest.getUri());
        HttpStreamingAsyncEntityProducer entityProducer = null;
        HttpEntity httpEntity = classicRequest.getEntity();
        if (httpEntity instanceof InputStreamEntity) {
            InputStreamEntity entity = (InputStreamEntity)httpEntity;
            entityProducer = new HttpStreamingAsyncEntityProducer(entity.getContent(), entity.getContentType());
        }
        return new BasicRequestProducer((HttpRequest)asyncRequest, entityProducer);
    }

    private void validateHttpClientParameters(String action, Map<String, String> parameters) throws Exception {
        String endpoint = this.connector.getActionEndpoint(action, parameters);
        URL url = new URL(endpoint);
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        MLHttpClientFactory.validate(protocol, host, port, this.connectorPrivateIpEnabled);
    }
}

