/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class HttpStreamingAsyncEntityProducer
implements AsyncEntityProducer {
    private static final int BUFFER_SIZE = 8192;
    private final InputStream inputStream;
    private final String contentType;
    private final AtomicBoolean endOfStream = new AtomicBoolean(false);

    public HttpStreamingAsyncEntityProducer(InputStream inputStream, String contentType) {
        this.inputStream = (InputStream)Args.notNull((Object)inputStream, (String)"InputStream");
        this.contentType = contentType;
    }

    public boolean isRepeatable() {
        return false;
    }

    public int available() {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.endOfStream.get()) {
            channel.endStream();
            return;
        }
        byte[] buffer = new byte[8192];
        int bytesRead = this.inputStream.read(buffer);
        if (bytesRead == -1) {
            this.endOfStream.set(true);
            channel.endStream();
        } else {
            channel.write(ByteBuffer.wrap(buffer, 0, bytesRead));
        }
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return true;
    }

    public Set<String> getTrailerNames() {
        return Set.of();
    }

    public void releaseResources() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void failed(Exception ex) {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

