/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLHttpClientFactory {
    private static final Logger log = LogManager.getLogger(MLHttpClientFactory.class);
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;

    public static CloseableHttpAsyncClient getAsyncHttpClient(Duration connectionTimeout, Duration readTimeout, int maxConnections, double maxConnectionsPerRouteAsPercent) {
        try {
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(SSLContext.getDefault()).setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
            int maxConn = maxConnections <= 0 ? 30 : maxConnections;
            int maxConnPerRoute = (int)((maxConnectionsPerRouteAsPercent <= 0.0 ? 0.3333333333333333 : maxConnectionsPerRouteAsPercent) * (double)maxConn);
            Duration timeout = connectionTimeout.compareTo(readTimeout) < 0 ? readTimeout : connectionTimeout;
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setSocketTimeout(Timeout.of((Duration)timeout)).build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnPerRoute(maxConnPerRoute).setMaxConnTotal(maxConn).setDefaultConnectionConfig(connectionConfig).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX).setTlsStrategy(tlsStrategy).build();
            HttpAsyncClientBuilder finalBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(RequestConfig.DEFAULT).setConnectionManager((AsyncClientConnectionManager)connectionManager).setTargetAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).disableAutomaticRetries();
            return AccessController.doPrivileged(() -> ((HttpAsyncClientBuilder)finalBuilder).build());
        }
        catch (NoSuchAlgorithmException | PrivilegedActionException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public static void validate(String protocol, String host, int port, AtomicBoolean connectorPrivateIpEnabled) throws UnknownHostException {
        if (protocol != null && !"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            log.error("Remote inference protocol is not http or https: " + protocol);
            throw new IllegalArgumentException("Protocol is not http or https: " + protocol);
        }
        if (port == -1) {
            port = protocol == null || "http".equals(protocol.toLowerCase(Locale.getDefault())) ? 80 : 443;
        }
        if (port < 0 || port > 65536) {
            log.error("Remote inference port out of range: " + port);
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        MLHttpClientFactory.validateIp(host, connectorPrivateIpEnabled);
    }

    private static void validateIp(String hostName, AtomicBoolean connectorPrivateIpEnabled) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        if ((connectorPrivateIpEnabled == null || !connectorPrivateIpEnabled.get()) && MLHttpClientFactory.hasPrivateIpAddress(addresses)) {
            log.error("Remote inference host name has private ip address: " + hostName);
            throw new IllegalArgumentException("Remote inference host name has private ip address: " + hostName);
        }
    }

    private static boolean hasPrivateIpAddress(InetAddress[] ipAddress) {
        for (InetAddress ip : ipAddress) {
            if (!(ip instanceof Inet4Address)) continue;
            byte[] bytes = ip.getAddress();
            if (bytes.length != 4) {
                return true;
            }
            int firstOctets = bytes[0] & 0xFF;
            int firstInOctal = MLHttpClientFactory.parseWithOctal(String.valueOf(firstOctets));
            int firstInHex = Integer.parseInt(String.valueOf(firstOctets), 16);
            if (firstInOctal == 127 || firstInHex == 127) {
                return bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 1;
            }
            if (firstInOctal == 10 || firstInHex == 10) {
                return true;
            }
            if (firstInOctal == 172 || firstInHex == 172) {
                int secondOctets = bytes[1] & 0xFF;
                int secondInOctal = MLHttpClientFactory.parseWithOctal(String.valueOf(secondOctets));
                int secondInHex = Integer.parseInt(String.valueOf(secondOctets), 16);
                return secondInOctal >= 16 && secondInOctal <= 32 || secondInHex >= 16 && secondInHex <= 32;
            }
            if (firstInOctal != 192 && firstInHex != 192) continue;
            int secondOctets = bytes[1] & 0xFF;
            int secondInOctal = MLHttpClientFactory.parseWithOctal(String.valueOf(secondOctets));
            int secondInHex = Integer.parseInt(String.valueOf(secondOctets), 16);
            return secondInOctal == 168 || secondInHex == 168;
        }
        return Arrays.stream(ipAddress).anyMatch(x -> x.isSiteLocalAddress() || x.isLoopbackAddress() || x.isAnyLocalAddress());
    }

    private static int parseWithOctal(String input) {
        try {
            return Integer.parseInt(input, 8);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(input);
        }
    }
}

