/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.remote;

import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.ScriptService;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.exception.MLException;
import io.skylite.ml.common.model.MLGuard;
import io.skylite.ml.common.output.model.ModelTensors;
import io.skylite.ml.common.remote.ConnectorUtils;
import io.skylite.ml.common.remote.ExecutionContext;
import io.skylite.ml.common.remote.RemoteConnectorThrottlingException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AbstractAsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;

public class MLSdkAsyncHttpResponseHandler
extends AbstractAsyncResponseConsumer<SimpleHttpResponse, String> {
    private static final Logger log = LogManager.getLogger(MLSdkAsyncHttpResponseHandler.class);
    public static final String ERROR_HEADER = "x-error-type";
    private Integer statusCode;
    private final StringBuilder responseBody = new StringBuilder();
    private final ExecutionContext executionContext;
    private final ActionListener<Tuple<Integer, ModelTensors>> actionListener;
    private final Map<String, String> parameters;
    private final Connector connector;
    private final String action;
    private final ScriptService scriptService;
    private final MLGuard mlGuard;
    private AtomicReference<Exception> exceptionHolder = new AtomicReference();

    public MLSdkAsyncHttpResponseHandler(ExecutionContext executionContext, ActionListener<Tuple<Integer, ModelTensors>> actionListener, Map<String, String> parameters, Connector connector, ScriptService scriptService, MLGuard mlGuard, String action) {
        super(() -> new AbstractCharAsyncEntityConsumer(){
            private final StringBuilder responseBuffer = new StringBuilder();
            private final AtomicReference<Exception> exceptionHolder = new AtomicReference();

            protected void streamStart(ContentType contentType) {
            }

            protected int capacityIncrement() {
                return 8192;
            }

            protected void data(CharBuffer data, boolean endOfStream) {
                try {
                    this.responseBuffer.append(data);
                }
                catch (Exception e) {
                    log.error("Error while processing response body: {}", (Object)e.getMessage());
                    this.exceptionHolder.compareAndSet(null, e);
                }
            }

            protected String generateContent() {
                return this.responseBuffer.toString();
            }

            public void releaseResources() {
                this.responseBuffer.setLength(0);
            }
        });
        this.executionContext = executionContext;
        this.actionListener = actionListener;
        this.parameters = parameters;
        this.connector = connector;
        this.scriptService = scriptService;
        this.mlGuard = mlGuard;
        this.action = action;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public StringBuilder getResponseBody() {
        return this.responseBody;
    }

    protected SimpleHttpResponse buildResult(HttpResponse response, String entity, ContentType contentType) {
        log.debug("Received response headers: {}", (Object)Arrays.toString(response.getHeaders()));
        this.statusCode = response.getCode();
        if (this.statusCode < 200 || this.statusCode > 300) {
            log.error("Received error from remote service with status code {}, response headers: {}", (Object)this.statusCode, (Object)Arrays.toString(response.getHeaders()));
            this.handleThrottlingInHeader(response);
        }
        this.processResponse(entity);
        return new SimpleHttpResponse(response.getCode(), response.getReasonPhrase());
    }

    public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
    }

    public void handleResponseHeaders(int statusCode, String headers) {
        this.statusCode = statusCode;
        log.debug("Received response headers: \n{}", (Object)headers);
    }

    public void handleFailure(Exception ex) {
        log.error("Received error from remote service: {}", (Object)ex.getMessage());
        RestStatus status = this.statusCode == null ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.fromCode((int)this.statusCode);
        String errorMessage = "Error communicating with remote model: " + ex.getMessage();
        this.actionListener.onFailure((Exception)new SkyliteStatusException(errorMessage, status, new Object[0]));
    }

    private SimpleHttpResponse handleException(Exception e) {
        log.error("Received error from remote service: {}", (Object)e.getMessage());
        RestStatus status = this.statusCode == null ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.fromCode((int)this.statusCode);
        String errorMessage = "Error communicating with remote model: " + e.getMessage();
        this.actionListener.onFailure((Exception)new SkyliteStatusException(errorMessage, status, new Object[0]));
        return new SimpleHttpResponse(500, "Error processing response");
    }

    protected void handleThrottlingInHeader(HttpResponse response) {
        this.statusCode = response.getCode();
        if (response.getHeaders() == null || response.getHeaders().length == 0) {
            log.debug("No headers in response");
            return;
        }
        Header[] errorHeaders = response.getHeaders(ERROR_HEADER);
        if (errorHeaders == null || errorHeaders.length == 0) {
            return;
        }
        List errorsInHeader = Arrays.stream(errorHeaders).map(NameValuePair::getValue).collect(Collectors.toList());
        boolean containsThrottlingException = errorsInHeader.stream().anyMatch(str -> str.startsWith("ThrottlingException"));
        if (containsThrottlingException) {
            log.error("Remote server returned error code: {}", (Object)this.statusCode);
            this.handleException((Exception)new RemoteConnectorThrottlingException("Error from remote service: The request was denied due to remote server throttling. To change the retry policy and behavior, please update the connector client_config.", RestStatus.fromCode((int)this.statusCode), new Object[0]));
        }
    }

    protected void processResponse(String body) {
        if (this.exceptionHolder.get() != null) {
            log.error("Remote server returned exception with status code: {} and body: {}", (Object)this.statusCode, (Object)body);
            this.actionListener.onFailure(this.exceptionHolder.get());
            return;
        }
        if (Strings.isBlank((String)body) && !this.action.equals(ConnectorAction.ActionType.CANCEL_BATCH_PREDICT.toString())) {
            log.error("Remote model response body is empty!");
            this.actionListener.onFailure((Exception)new SkyliteStatusException("No response from model", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        if (this.statusCode < 200 || this.statusCode > 300) {
            log.error("Remote service returned error code: {} with body: {}", (Object)this.statusCode, (Object)body);
            this.actionListener.onFailure((Exception)new SkyliteStatusException("Error from remote service: " + body, RestStatus.fromCode((int)this.statusCode), new Object[0]));
            return;
        }
        if (this.action.equals(ConnectorAction.ActionType.CANCEL_BATCH_PREDICT.toString())) {
            ModelTensors tensors = ModelTensors.builder().statusCode(this.statusCode).build();
            tensors.setStatusCode(this.statusCode);
            this.actionListener.onResponse((Object)new Tuple((Object)this.executionContext.getSequence(), (Object)tensors));
            return;
        }
        try {
            ModelTensors tensors = ConnectorUtils.processOutput((String)this.action, (String)body, (Connector)this.connector, (ScriptService)this.scriptService, this.parameters, (MLGuard)this.mlGuard);
            tensors.setStatusCode(this.statusCode);
            this.actionListener.onResponse((Object)new Tuple((Object)this.executionContext.getSequence(), (Object)tensors));
        }
        catch (Exception e) {
            log.error("Failed to process response body: {}", (Object)body);
            this.actionListener.onFailure((Exception)new MLException("Fail to execute " + this.action + " in MLSdkAsyncHttpResponseHandler", (Throwable)e));
        }
    }
}

