/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import com.fasterxml.jackson.databind.JsonNode;
import io.skylite.common.Nullable;
import io.skylite.common.util.ArrayUtils;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.ml.common.Constants;
import io.skylite.ml.common.connector.ConnectorAction;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BytesRestResponse;

public class RestActionUtils {
    private static final Logger logger = LogManager.getLogger(RestActionUtils.class);
    public static final String LUCENIA_SECURITY_CONFIG_PREFIX = "_opendistro_security_";
    public static final String LUCENIA_SECURITY_USER = "_opendistro_security_user";
    static final Set<LdapName> adminDn = new HashSet<LdapName>();
    static final Set<String> adminUsernames = new HashSet<String>();

    public static String getAlgorithm(RestRequest request) {
        String algorithm = request.param("algorithm");
        if (Strings.isNullOrEmpty((String)algorithm)) {
            throw new IllegalArgumentException("Request should contain algorithm!");
        }
        return algorithm.toUpperCase(Locale.ROOT);
    }

    public static boolean isAsync(RestRequest request) {
        return request.paramAsBoolean("async", false);
    }

    public static boolean returnContent(RestRequest request) {
        return request.paramAsBoolean("return_content", false);
    }

    public static String getParameterId(RestRequest request, String idName) {
        String id = request.param(idName);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("Request should contain " + idName);
        }
        return id;
    }

    public static FetchSourceContext getSourceContext(RestRequest request, SearchSourceBuilder searchSourceBuilder) {
        String userAgent = RestActionUtils.coalesceToEmpty(request.header("User-Agent"));
        if (searchSourceBuilder.fetchSource() != null) {
            Object[] includes = searchSourceBuilder.fetchSource().includes();
            Object[] excludes = searchSourceBuilder.fetchSource().excludes();
            if (!ArrayUtils.contains((Object[])includes, (Object)"model_content")) {
                ArrayUtils.add((Object[])excludes, (Object)"model_content");
            }
            if (!ArrayUtils.contains((Object[])includes, (Object)"content")) {
                ArrayUtils.add((Object[])excludes, (Object)"content");
            }
            String[] metadataExcludes = new String[excludes.length + 1];
            if (!userAgent.contains("OpenSearch Dashboards")) {
                if (excludes.length == 0) {
                    return new FetchSourceContext(true, (String[])includes, Constants.RestActions.UI_METADATA_EXCLUDE);
                }
                System.arraycopy(excludes, 0, metadataExcludes, 0, excludes.length);
                metadataExcludes[metadataExcludes.length - 1] = "ui_metadata";
                return new FetchSourceContext(true, (String[])includes, metadataExcludes);
            }
            return new FetchSourceContext(true, (String[])includes, (String[])excludes);
        }
        Object[] excludes = new String[]{"content", "model_content"};
        if (!userAgent.contains("OpenSearch Dashboards")) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])ArrayUtils.add((Object[])excludes, (Object)"ui_metadata"));
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, (String[])excludes);
    }

    public static FetchSourceContext getFetchSourceContext(boolean returnModelContent) {
        if (!returnModelContent) {
            return new FetchSourceContext(true, Strings.EMPTY_ARRAY, new String[]{"content", "model_content"});
        }
        return new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    public static String[] getAllNodes(ClusterService clusterService) {
        Iterator iterator = clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }

    public static String getActionTypeFromRestRequest(RestRequest request) {
        String path = request.path();
        String[] segments = path.split("/");
        String methodName = segments[segments.length - 1];
        String string = methodName = methodName.startsWith("_") ? methodName.substring(1) : methodName;
        if (!ConnectorAction.ActionType.isValidAction((String)methodName) && segments.length > 3) {
            methodName = segments[3];
            methodName = methodName.contains("_") ? methodName.split("_")[1] : methodName;
        }
        return methodName;
    }

    public static void onFailure(RestChannel channel, RestStatus status, String errorMessage, Exception exception) {
        BytesRestResponse bytesRestResponse;
        try {
            bytesRestResponse = new BytesRestResponse(channel, exception);
        }
        catch (Exception e) {
            bytesRestResponse = new BytesRestResponse(status, errorMessage);
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    public static Optional<String[]> splitCommaSeparatedParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName)).map(s -> s.split(","));
    }

    private static String coalesceToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    public static Optional<String> getStringParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName));
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Current user is " + userStr);
        return User.parse((String)userStr);
    }

    public static boolean isSuperAdminUser(ClusterService clusterService, Client client) {
        List adminDnsA = clusterService.getSettings().getAsList("plugins.security.authcz.admin_dn", Collections.emptyList());
        for (String dn : adminDnsA) {
            try {
                logger.debug("{} is registered as an admin dn", (Object)dn);
                adminDn.add(new LdapName(dn));
            }
            catch (InvalidNameException e) {
                logger.debug("Unable to parse admin dn {}", (Object)dn);
                adminUsernames.add(dn);
            }
        }
        Object userObject = client.threadPool().getThreadContext().getTransient(LUCENIA_SECURITY_USER);
        if (userObject == null) {
            return false;
        }
        try {
            return AccessController.doPrivileged(() -> {
                String userContext = Strings.OBJECT_MAPPER.writeValueAsString(userObject);
                JsonNode node = Strings.OBJECT_MAPPER.readTree(userContext);
                String userName = node.get("name").asText();
                return RestActionUtils.isAdminDN(userName);
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAdminDN(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return RestActionUtils.isAdminDN(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return adminUsernames.contains(dn);
        }
    }

    private static boolean isAdminDN(LdapName dn) {
        if (dn == null) {
            return false;
        }
        boolean isAdmin = adminDn.contains(dn);
        if (logger.isTraceEnabled()) {
            logger.trace("Is principal {} an admin cert? {}", (Object)dn.toString(), (Object)isAdmin);
        }
        return isAdmin;
    }
}

