/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.controller.MLController;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.controller.MLCreateControllerAction;
import io.skylite.ml.common.transport.controller.MLCreateControllerRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLCreateControllerAction
extends MLRestHandler {
    public static final String ML_CREATE_CONTROLLER_ACTION = "ml_create_controller_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLCreateControllerAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_CREATE_CONTROLLER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/controllers/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLCreateControllerRequest createControllerRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCreateControllerAction.INSTANCE, (ActionRequest)createControllerRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLCreateControllerRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
            throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
        }
        if (!request.hasContent()) {
            throw new SkyliteParseException("Create model controller request has empty body", new Object[0]);
        }
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLController controllerInput = MLController.parse((XContentParser)parser);
        controllerInput.setModelId(modelId);
        return new MLCreateControllerRequest(controllerInput);
    }
}

