/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLConnectorDeleteAction;
import io.skylite.ml.common.transport.connector.MLConnectorDeleteRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeleteConnectorAction
extends MLRestHandler {
    private static final String ML_DELETE_CONNECTOR_ACTION = "ml_delete_connector_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteConnectorAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/connectors/{%s}", "/_plugins/_ml", "connector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String connectorId = request.param("connector_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        MLConnectorDeleteRequest mlConnectorDeleteRequest = new MLConnectorDeleteRequest(connectorId, tenantId);
        return channel -> client.execute((ActionType)MLConnectorDeleteAction.INSTANCE, (ActionRequest)mlConnectorDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

