/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLModelGroupDeleteAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupDeleteRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeleteModelGroupAction
extends MLRestHandler {
    private static final String ML_DELETE_MODEL_GROUP_ACTION = "ml_delete_model_group_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/model_groups/{%s}", "/_plugins/_ml", "model_group_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String modelGroupId = request.param("model_group_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        MLModelGroupDeleteRequest mlModelGroupDeleteRequest = new MLModelGroupDeleteRequest(modelGroupId, tenantId);
        return channel -> client.execute((ActionType)MLModelGroupDeleteAction.INSTANCE, (ActionRequest)mlModelGroupDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

