/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLConnectorGetAction;
import io.skylite.ml.common.transport.connector.MLConnectorGetRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetConnectorAction
extends MLRestHandler {
    private static final String ML_GET_CONNECTOR_ACTION = "ml_get_connector_action";
    private ClusterService clusterService;
    private Settings settings;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetConnectorAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/connectors/{%s}", "/_plugins/_ml", "connector_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLConnectorGetRequest mlConnectorGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLConnectorGetAction.INSTANCE, (ActionRequest)mlConnectorGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLConnectorGetRequest getRequest(RestRequest request) throws IOException {
        String connectorId = RestActionUtils.getParameterId(request, "connector_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        return new MLConnectorGetRequest(connectorId, tenantId, returnContent);
    }
}

