/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.ToolMetadata;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.transport.tools.MLGetToolAction;
import io.skylite.ml.common.transport.tools.MLToolGetRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetToolAction
extends MLRestHandler {
    private static final String ML_GET_TOOL_ACTION = "ml_get_tool_action";
    private final Map<String, Tool.Factory<?>> toolFactories;

    public RestMLGetToolAction(Map<String, Tool.Factory<?>> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public String getName() {
        return ML_GET_TOOL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tools/{%s}", "/_plugins/_ml", "tool_name")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLToolGetRequest mlToolGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLGetToolAction.INSTANCE, (ActionRequest)mlToolGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLToolGetRequest getRequest(RestRequest request) throws IOException {
        ArrayList toolList = new ArrayList();
        this.toolFactories.forEach((key, value) -> toolList.add(ToolMetadata.builder().name(key).description(value.getDefaultDescription()).type(value.getDefaultType()).version(value.getDefaultVersion()).build()));
        String toolName = RestActionUtils.getParameterId(request, "tool_name");
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.builder().toolName(toolName).toolMetadataList(toolList).build();
        return mlToolGetRequest;
    }
}

