/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.ToolMetadata;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.transport.tools.MLListToolsAction;
import io.skylite.ml.common.transport.tools.MLToolsListRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLListToolsAction
extends MLRestHandler {
    private static final String ML_LIST_TOOLS_ACTION = "ml_list_tools_action";
    private final Map<String, Tool.Factory<?>> toolFactories;

    public RestMLListToolsAction(Map<String, Tool.Factory<?>> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public String getName() {
        return ML_LIST_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tools", "/_plugins/_ml")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLToolsListRequest mlToolsListRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLListToolsAction.INSTANCE, (ActionRequest)mlToolsListRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLToolsListRequest getRequest(RestRequest request) throws IOException {
        ArrayList toolList = new ArrayList();
        this.toolFactories.forEach((key, value) -> toolList.add(ToolMetadata.builder().name(key).description(value.getDefaultDescription()).type(value.getDefaultType()).version(value.getDefaultVersion()).attributes(value.getDefaultAttributes()).build()));
        MLToolsListRequest mlToolsGetRequest = MLToolsListRequest.builder().toolMetadataList(toolList).build();
        return mlToolsGetRequest;
    }
}

