/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.register.MLRegisterModelAction;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import io.skylite.ml.common.transport.register.MLRegisterModelRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLRegisterModelAction
extends MLRestHandler {
    private static final String ML_REGISTER_MODEL_ACTION = "ml_register_model_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLRegisterModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public RestMLRegisterModelAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_register", "/_plugins/_ml"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_upload", "/_plugins/_ml")), new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/{%s}/_register", "/_plugins/_ml", "model_id", "version"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/{%s}/_upload", "/_plugins/_ml", "model_id", "version")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLRegisterModelRequest mlRegisterModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLRegisterModelAction.INSTANCE, (ActionRequest)mlRegisterModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLRegisterModelRequest getRequest(RestRequest request) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        boolean loadModel = request.paramAsBoolean("deploy", false);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLRegisterModelInput mlInput = MLRegisterModelInput.parse((XContentParser)parser, (boolean)loadModel);
        mlInput.setTenantId(tenantId);
        if (mlInput.getFunctionName() == FunctionName.REMOTE && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (FunctionName.isDLModel((FunctionName)mlInput.getFunctionName()) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        return new MLRegisterModelRequest(mlInput);
    }
}

