/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaAction;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLRegisterModelMetaAction
extends MLRestHandler {
    private static final String ML_REGISTER_MODEL_META_ACTION = "ml_register_model_meta_action";
    private volatile boolean isLocalFileUploadAllowed;

    public RestMLRegisterModelMetaAction(ClusterService clusterService, Settings settings) {
        this.isLocalFileUploadAllowed = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD, it -> {
            this.isLocalFileUploadAllowed = it;
        });
    }

    public String getName() {
        return ML_REGISTER_MODEL_META_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_register_meta", "/_plugins/_ml"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/meta", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLRegisterModelMetaRequest mlRegisterModelMetaRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLRegisterModelMetaAction.INSTANCE, (ActionRequest)mlRegisterModelMetaRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLRegisterModelMetaRequest getRequest(RestRequest request) throws IOException {
        boolean hasContent = request.hasContent();
        if (!this.isLocalFileUploadAllowed) {
            throw new IllegalArgumentException("To upload custom model from local file, user needs to enable allow_registering_model_via_local_file settings. Otherwise please use opensearch pre-trained models");
        }
        if (!hasContent) {
            throw new IOException("Model meta request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLRegisterModelMetaInput mlInput = MLRegisterModelMetaInput.parse((XContentParser)parser);
        return new MLRegisterModelMetaRequest(mlInput);
    }
}

