/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.input.TransportMLInput;
import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.transport.training.MLTrainingTaskAction;
import io.skylite.ml.common.transport.training.MLTrainingTaskRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLTrainingAction
extends MLRestHandler {
    private static final String ML_TRAINING_ACTION = "ml_training_action";

    public String getName() {
        return ML_TRAINING_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_train/{%s}", "/_plugins/_ml", "algorithm")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLTrainingTaskRequest mlTrainingTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLTrainingTaskAction.INSTANCE, (ActionRequest)mlTrainingTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLTrainingTaskRequest getRequest(RestRequest request) throws IOException {
        String algorithm = RestActionUtils.getAlgorithm(request);
        boolean async = RestActionUtils.isAsync(request);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = TransportMLInput.parse(parser, algorithm);
        return new MLTrainingTaskRequest(mlInput, async);
    }
}

