/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.ArrayUtils;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelInput;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelsAction;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelsRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUndeployModelAction
extends MLRestHandler {
    private static final String ML_UNDEPLOY_MODEL_ACTION = "ml_undeploy_model_action";
    private ClusterService clusterService;
    private Settings settings;
    private boolean allowCustomDeploymentPlan;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUndeployModelAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.allowCustomDeploymentPlan = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN.get(settings);
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, it -> {
            this.allowCustomDeploymentPlan = it;
        });
    }

    public String getName() {
        return ML_UNDEPLOY_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_undeploy", "/_plugins/_ml", "model_id"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_unload", "/_plugins/_ml", "model_id")), new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_undeploy", "/_plugins/_ml"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_unload", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUndeployModelsRequest mlUndeployModelsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUndeployModelsAction.INSTANCE, (ActionRequest)mlUndeployModelsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLUndeployModelsRequest getRequest(RestRequest request) throws IOException {
        Object[] targetNodeIds;
        String modelId = request.param("model_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        Object[] targetModelIds = null;
        if (modelId != null) {
            targetModelIds = new String[]{modelId};
        }
        if (request.hasContent()) {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLUndeployModelInput mlInput = MLUndeployModelInput.parse((XContentParser)parser);
            Object[] nodeIds = mlInput.getNodeIds();
            Object[] modelIds = mlInput.getModelIds();
            if (!ArrayUtils.isEmpty((Object[])nodeIds)) {
                if (!this.allowCustomDeploymentPlan) {
                    throw new IllegalArgumentException("Don't allow custom deployment plan");
                }
                targetNodeIds = nodeIds;
            } else {
                targetNodeIds = RestActionUtils.getAllNodes(this.clusterService);
            }
            if (!ArrayUtils.isEmpty((Object[])modelIds)) {
                targetModelIds = modelIds;
            }
        } else {
            targetNodeIds = RestActionUtils.getAllNodes(this.clusterService);
        }
        return new MLUndeployModelsRequest((String[])targetModelIds, (String[])targetNodeIds, tenantId);
    }
}

