/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.connector.MLUpdateConnectorAction;
import io.skylite.ml.common.transport.connector.MLUpdateConnectorRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUpdateConnectorAction
extends MLRestHandler {
    private static final String ML_UPDATE_CONNECTOR_ACTION = "ml_update_connector_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateConnectorAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/connectors/{%s}", "/_plugins/_ml", "connector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateConnectorRequest mlUpdateConnectorRequest = this.getRequest(request);
        return restChannel -> client.execute((ActionType)MLUpdateConnectorAction.INSTANCE, (ActionRequest)mlUpdateConnectorRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    private MLUpdateConnectorRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (!request.hasContent()) {
            throw new SkyliteParseException("Failed to update connector: Request body is empty", new Object[0]);
        }
        String connectorId = RestActionUtils.getParameterId(request, "connector_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            return MLUpdateConnectorRequest.parse((XContentParser)parser, (String)connectorId, (String)tenantId);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SkyliteParseException(illegalStateException.getMessage(), new Object[0]);
        }
    }
}

