/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteParseException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model.MLUpdateModelAction;
import io.skylite.ml.common.transport.model.MLUpdateModelInput;
import io.skylite.ml.common.transport.model.MLUpdateModelRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUpdateModelAction
extends MLRestHandler {
    private static final String ML_UPDATE_MODEL_ACTION = "ml_update_model_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/models/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateModelRequest updateModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUpdateModelAction.INSTANCE, (ActionRequest)updateModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLUpdateModelRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new SkyliteParseException("Update model request has empty body", new Object[0]);
        }
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        try {
            MLUpdateModelInput input = MLUpdateModelInput.parse((XContentParser)parser);
            if (input.getConnectorId() != null && input.getConnector() != null) {
                throw new SkyliteStatusException("Model cannot have both stand-alone connector and internal connector. Please check your update input body.", RestStatus.BAD_REQUEST, new Object[0]);
            }
            input.setModelId(modelId);
            input.setVersion(null);
            input.setUpdatedConnector(null);
            input.setTenantId(tenantId);
            return new MLUpdateModelRequest(input);
        }
        catch (IllegalStateException e) {
            throw new SkyliteParseException(e.getMessage(), new Object[0]);
        }
    }
}

