/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupAction;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupInput;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUpdateModelGroupAction
extends MLRestHandler {
    private static final String ML_UPDATE_MODEL_GROUP_ACTION = "ml_update_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/model_groups/{%s}", "/_plugins/_ml", "model_group_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateModelGroupRequest updateModelGroupRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUpdateModelGroupAction.INSTANCE, (ActionRequest)updateModelGroupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLUpdateModelGroupRequest getRequest(RestRequest request) throws IOException {
        String modelGroupID = RestActionUtils.getParameterId(request, "model_group_id");
        String tenantId = TenantAwareHelper.getTenantID((Boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (RestRequest)request);
        boolean hasContent = request.hasContent();
        if (!hasContent) {
            throw new IOException("Model group request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLUpdateModelGroupInput input = MLUpdateModelGroupInput.parse((XContentParser)parser);
        input.setModelGroupID(modelGroupID);
        input.setTenantId(tenantId);
        return new MLUpdateModelGroupRequest(input);
    }
}

