/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkAction;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkInput;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkRequest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUploadModelChunkAction
extends MLRestHandler {
    private static final String ML_UPLOAD_MODEL_CHUNK_ACTION = "ml_upload_model_chunk_action";
    private volatile boolean isLocalFileUploadAllowed;

    public RestMLUploadModelChunkAction(ClusterService clusterService, Settings settings) {
        this.isLocalFileUploadAllowed = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD, it -> {
            this.isLocalFileUploadAllowed = it;
        });
    }

    public String getName() {
        return ML_UPLOAD_MODEL_CHUNK_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/upload_chunk/{%s}", "/_plugins/_ml", "model_id", "chunk_number"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/chunk/{%s}", "/_plugins/_ml", "model_id", "chunk_number")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUploadModelChunkRequest mlUploadModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUploadModelChunkAction.INSTANCE, (ActionRequest)mlUploadModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLUploadModelChunkRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        String chunk_number = request.param("chunk_number");
        byte[] content = request.content().streamInput().readAllBytes();
        if (!this.isLocalFileUploadAllowed) {
            throw new IllegalArgumentException("To upload custom model from local file, user needs to enable allow_registering_model_via_local_file settings. Otherwise please use opensearch pre-trained models.");
        }
        MLUploadModelChunkInput mlInput = new MLUploadModelChunkInput(modelId, Integer.valueOf(Integer.parseInt(chunk_number)), content);
        return new MLUploadModelChunkRequest(mlInput);
    }
}

