/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest.mcpserver;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRegisterAction;
import io.lucenia.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import io.lucenia.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodesRequest;
import io.lucenia.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

@ExperimentalApi
public class RestMLMcpToolsRegisterAction
extends MLRestHandler {
    private static final Logger log = LogManager.getLogger(RestMLMcpToolsRegisterAction.class);
    private static final String ML_REGISTER_MCP_TOOLS_ACTION = "ml_register_mcp_tools_action";
    private final Map<String, Tool.Factory<? extends Tool>> toolFactories;
    private ClusterService clusterService;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLMcpToolsRegisterAction(Map<String, Tool.Factory<? extends Tool>> toolFactories, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.toolFactories = toolFactories;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MCP_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        String ML_BASE_URI = "/_plugins/_ml";
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/mcp/tools/_register", ML_BASE_URI)));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            throw new SkyliteException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]);
        }
        ActionRequestValidationException exception = new ActionRequestValidationException();
        MLMcpToolsRegisterNodesRequest registerNodesRequest = this.getRequest(request);
        if (CollectionUtils.isEmpty(registerNodesRequest.getMcpTools())) {
            exception.addValidationError("tools list can not be null");
            throw exception;
        }
        String duplicateName = null;
        HashSet<String> uniqueName = new HashSet<String>();
        for (McpToolRegisterInput mcpTool : registerNodesRequest.getMcpTools()) {
            if (uniqueName.contains(mcpTool.getName())) {
                duplicateName = mcpTool.getName();
                break;
            }
            uniqueName.add(mcpTool.getName());
        }
        if (duplicateName != null) {
            exception.addValidationError(String.format(Locale.ROOT, "duplicate tool name: %s found in the request", duplicateName));
            throw exception;
        }
        Set buildInToolNames = this.toolFactories.values().stream().map(Tool.Factory::getDefaultType).collect(Collectors.toSet());
        Set unrecognizedTools = registerNodesRequest.getMcpTools().stream().map(McpToolBaseInput::getType).filter(type -> !buildInToolNames.contains(type)).collect(Collectors.toSet());
        if (!unrecognizedTools.isEmpty()) {
            exception.addValidationError(String.format(Locale.ROOT, "Unrecognized tool in request: %s", unrecognizedTools));
            throw exception;
        }
        return channel -> client.execute((ActionType)MLMcpToolsRegisterAction.INSTANCE, (ActionRequest)registerNodesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLMcpToolsRegisterNodesRequest getRequest(RestRequest request) throws IOException {
        XContentParser parser = request.contentParser();
        return MLMcpToolsRegisterNodesRequest.parse(parser, this.clusterService.state().nodes().getNodes().keySet().toArray(new String[0]));
    }
}

