/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.rest.mcpserver;

import io.lucenia.ml.common.rest.MLRestHandler;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRemoveAction;
import io.lucenia.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

@ExperimentalApi
public class RestMLMcpToolsRemoveAction
extends MLRestHandler {
    private static final Logger log = LogManager.getLogger(RestMLMcpToolsRemoveAction.class);
    private static final String ML_REGISTER_MCP_TOOLS_ACTION = "ml_remove_mcp_tools_action";
    private final ClusterService clusterService;
    private static final String ML_BASE_URI = "/_plugins/_ml";
    private final String REMOVE_PATH = String.format(Locale.ROOT, "%s/mcp/tools/_remove", "/_plugins/_ml");
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLMcpToolsRemoveAction(ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MCP_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, this.REMOVE_PATH));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            throw new SkyliteException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]);
        }
        MLMcpToolsRemoveNodesRequest removeNodesRequest = this.getRequest(request);
        ActionRequestValidationException exception = new ActionRequestValidationException();
        if (CollectionUtils.isEmpty(removeNodesRequest.getMcpTools())) {
            exception.addValidationError("tools list can not be null");
            throw exception;
        }
        return channel -> client.execute((ActionType)MLMcpToolsRemoveAction.INSTANCE, (ActionRequest)removeNodesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLMcpToolsRemoveNodesRequest getRequest(RestRequest request) throws IOException {
        return MLMcpToolsRemoveNodesRequest.parse(request.contentParser(), this.clusterService.state().nodes().getNodes().keySet().toArray(new String[0]));
    }
}

