/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.task;

import io.lucenia.ml.common.engine.indices.MLInputDatasetHandler;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.lucenia.ml.common.task.MLTaskRunner;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.transport.execute.MLExecuteTaskRequest;
import io.skylite.ml.common.transport.execute.MLExecuteTaskResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLExecuteTaskRunner
extends MLTaskRunner<MLExecuteTaskRequest, MLExecuteTaskResponse> {
    private static final Logger log = LogManager.getLogger(MLExecuteTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;
    protected final DiscoveryNodeHelper nodeHelper;
    private final MLEngine mlEngine;
    private volatile Boolean isPythonModelEnabled;

    public MLExecuteTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, DiscoveryNodeHelper nodeHelper, MLEngine mlEngine) {
        super(mlTaskManager, mlStats, nodeHelper, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
        this.nodeHelper = nodeHelper;
        this.mlEngine = mlEngine;
        this.isPythonModelEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL.get(this.clusterService.getSettings());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL, it -> {
            this.isPythonModelEnabled = it;
        });
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/lucenia/ml/execute";
    }

    @Override
    protected TransportResponseHandler<MLExecuteTaskResponse> getResponseHandler(ActionListener<MLExecuteTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLExecuteTaskResponse::new);
    }

    @Override
    protected void executeTask(MLExecuteTaskRequest request, ActionListener<MLExecuteTaskResponse> listener) {
        this.threadPool.executor("lucenia_ml_execute").execute(() -> {
            try {
                this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
                this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                this.mlStats.createCounterStatIfAbsent(request.getFunctionName(), ActionName.EXECUTE, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                Input input = request.getInput();
                FunctionName functionName = request.getFunctionName();
                if (FunctionName.METRICS_CORRELATION.equals((Object)functionName) && !this.isPythonModelEnabled.booleanValue()) {
                    IllegalArgumentException exception = new IllegalArgumentException("This algorithm is not enabled from settings");
                    listener.onFailure((Exception)exception);
                    return;
                }
                this.mlEngine.execute(input, ActionListenerHelper.wrap(output -> {
                    MLExecuteTaskResponse response = new MLExecuteTaskResponse(functionName, output);
                    listener.onResponse((Object)response);
                }, e -> listener.onFailure(e)));
            }
            catch (Exception e2) {
                this.mlStats.createCounterStatIfAbsent(request.getFunctionName(), ActionName.EXECUTE, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
                listener.onFailure(e2);
            }
            finally {
                this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
            }
        });
    }
}

