/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.task;

import io.lucenia.ml.common.engine.indices.MLInputDatasetHandler;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.lucenia.ml.common.task.MLTaskRunner;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.support.ThreadedActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.input.Input;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLPredictionOutput;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.task.MLTask;
import io.skylite.ml.common.task.MLTaskState;
import io.skylite.ml.common.task.MLTaskType;
import io.skylite.ml.common.transport.MLTaskResponse;
import io.skylite.ml.common.transport.training.MLTrainingTaskRequest;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLTrainAndPredictTaskRunner
extends MLTaskRunner<MLTrainingTaskRequest, MLTaskResponse> {
    private static final Logger log = LogManager.getLogger(MLTrainAndPredictTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;
    protected final DiscoveryNodeHelper nodeFilter;
    private final MLEngine mlEngine;

    public MLTrainAndPredictTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, DiscoveryNodeHelper nodeFilter, MLEngine mlEngine) {
        super(mlTaskManager, mlStats, nodeFilter, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
        this.nodeFilter = nodeFilter;
        this.mlEngine = mlEngine;
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/lucenia/ml/trainAndPredict";
    }

    @Override
    protected TransportResponseHandler<MLTaskResponse> getResponseHandler(ActionListener<MLTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLTaskResponse::new);
    }

    @Override
    protected void executeTask(MLTrainingTaskRequest request, ActionListener<MLTaskResponse> listener) {
        MLInputDataType inputDataType = request.getMlInput().getInputDataset().getInputDataType();
        Instant now = Instant.now();
        MLTask mlTask = MLTask.builder().taskId(UUID.randomUUID().toString()).taskType(MLTaskType.TRAINING_AND_PREDICTION).inputType(inputDataType).functionName(request.getMlInput().getFunctionName()).state(MLTaskState.CREATED).workerNodes(List.of(this.clusterService.localNode().getId())).createTime(now).lastUpdateTime(now).async(false).build();
        MLInput mlInput = request.getMlInput();
        MLInputDataset inputDataset = mlInput.getInputDataset();
        if (inputDataset.getInputDataType().equals((Object)MLInputDataType.SEARCH_QUERY)) {
            ActionListener dataFrameActionListener = ActionListenerHelper.wrap(dataSet -> {
                MLInput newInput = mlInput.toBuilder().inputDataset(dataSet).build();
                this.trainAndPredict(mlTask, newInput, listener);
            }, e -> {
                log.error("Failed to generate DataFrame from search query", (Throwable)e);
                this.handlePredictFailure(mlTask, listener, (Exception)e, false);
            });
            this.mlInputDatasetHandler.parseSearchQueryInput(inputDataset, (ActionListener<MLInputDataset>)new ThreadedActionListener(log, this.threadPool, "lucenia_ml_train", dataFrameActionListener, false));
        } else {
            this.threadPool.executor("lucenia_ml_train").execute(() -> this.trainAndPredict(mlTask, mlInput, listener));
        }
    }

    private void trainAndPredict(MLTask mlTask, MLInput mlInput, ActionListener<MLTaskResponse> listener) {
        ActionListener<MLTaskResponse> internalListener = this.wrappedCleanupListener(listener, mlTask.getTaskId());
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
        this.mlStats.getStat((Enum)MLNodeLevelStat.ML_REQUEST_COUNT).increment();
        this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.TRAIN_PREDICT, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
        mlTask.setState(MLTaskState.RUNNING);
        this.mlTaskManager.add(mlTask);
        try {
            this.mlTaskManager.updateTaskStateAsRunning(mlTask.getTaskId(), mlTask.getTenantId(), mlTask.isAsync());
            MLOutput output = this.mlEngine.trainAndPredict((Input)mlInput);
            this.handleAsyncMLTaskComplete(mlTask);
            if (output instanceof MLPredictionOutput) {
                ((MLPredictionOutput)output).setStatus(MLTaskState.COMPLETED.name());
            }
            MLTaskResponse response = MLTaskResponse.builder().output(output).build();
            log.debug("Train and predict task done for algorithm: {}, task id: {}", (Object)mlTask.getFunctionName(), (Object)mlTask.getTaskId());
            internalListener.onResponse((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to train and predict " + String.valueOf(mlInput.getAlgorithm()), (Throwable)e);
            this.handlePredictFailure(mlTask, listener, e, true);
            return;
        }
    }

    private void handlePredictFailure(MLTask mlTask, ActionListener<MLTaskResponse> listener, Exception e, boolean trackFailure) {
        if (trackFailure) {
            this.mlStats.createCounterStatIfAbsent(mlTask.getFunctionName(), ActionName.TRAIN_PREDICT, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
            this.mlStats.getStat((Enum)MLNodeLevelStat.ML_FAILURE_COUNT).increment();
        }
        this.handleAsyncMLTaskFailure(mlTask, e);
        listener.onFailure(e);
    }
}

