/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.transport.mcpserver.requests;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;

public class McpToolBaseInput
implements ToXContentObject,
Writeable {
    public static final String TOOL = "tool";
    public static final String TYPE_FIELD = "type";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMS_FIELD = "parameters";
    public static final String ATTRIBUTES_FIELD = "attributes";
    private String type;
    private String name;
    private String description;
    private Long version;
    private Map<String, Object> parameters;
    private Map<String, Object> attributes;
    private Instant createdTime;
    private Instant lastUpdatedTime;

    public McpToolBaseInput(StreamInput streamInput) throws IOException {
        this.type = streamInput.readString();
        this.name = streamInput.readOptionalString();
        this.description = streamInput.readOptionalString();
        if (streamInput.readBoolean()) {
            this.parameters = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        if (streamInput.readBoolean()) {
            this.attributes = streamInput.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
        this.createdTime = streamInput.readOptionalInstant();
        this.lastUpdatedTime = streamInput.readOptionalInstant();
        this.version = streamInput.readOptionalLong();
    }

    public McpToolBaseInput(String name, String type, String description, Map<String, Object> parameters, Map<String, Object> attributes, Instant createdTime, Instant lastUpdatedTime) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.parameters = parameters;
        this.attributes = attributes;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.type);
        streamOutput.writeOptionalString(this.name);
        streamOutput.writeOptionalString(this.description);
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
        if (this.attributes != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            streamOutput.writeBoolean(false);
        }
        streamOutput.writeOptionalInstant(this.createdTime);
        streamOutput.writeOptionalInstant(this.lastUpdatedTime);
        streamOutput.writeOptionalLong(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xcontentParams) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD, this.type);
        if (this.name != null) {
            builder.field(NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMS_FIELD, this.parameters);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.field(ATTRIBUTES_FIELD, this.attributes);
        }
        if (this.createdTime != null) {
            builder.field("create_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field("last_update_time", this.lastUpdatedTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

