/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.transport.mcpserver.requests.server;

import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class MLMcpServerResponse
extends ActionResponse
implements ToXContentObject {
    private Boolean acknowledgedResponse;
    private String mcpResponse;
    private Map<String, Object> error;

    public MLMcpServerResponse(Boolean acknowledgedResponse, String mcpResponse, Map<String, Object> error) {
        this.acknowledgedResponse = acknowledgedResponse;
        this.mcpResponse = mcpResponse;
        this.error = error;
    }

    public MLMcpServerResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledgedResponse = in.readOptionalBoolean();
        this.mcpResponse = in.readOptionalString();
        if (in.readBoolean()) {
            this.error = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.acknowledgedResponse);
        out.writeOptionalString(this.mcpResponse);
        if (this.error != null) {
            out.writeBoolean(true);
            out.writeMap(this.error, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            out.writeBoolean(false);
        }
    }

    public Boolean getAcknowledgedResponse() {
        return this.acknowledgedResponse;
    }

    public String getMcpResponse() {
        return this.mcpResponse;
    }

    public Map<String, Object> getError() {
        return this.error;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.acknowledgedResponse != null) {
            builder.field("acknowledged", this.acknowledgedResponse);
        }
        if (this.mcpResponse != null) {
            builder.field("mcp_response", this.mcpResponse);
        }
        if (this.error != null) {
            builder.field("error", this.error);
        }
        builder.endObject();
        return builder;
    }
}

