/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.utils;

import io.lucenia.jobscheduler.ScheduledJobProvider;
import io.lucenia.jobscheduler.model.ExtensionJobParameter;
import io.lucenia.jobscheduler.model.JobDetails;
import io.lucenia.jobscheduler.transport.request.ExtensionJobActionRequest;
import io.lucenia.jobscheduler.transport.request.JobParameterRequest;
import io.lucenia.jobscheduler.transport.request.JobRunnerRequest;
import io.lucenia.jobscheduler.transport.response.JobParameterResponse;
import io.lucenia.jobscheduler.transport.response.JobRunnerResponse;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.engine.DocumentMissingException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.jobs.JobDocVersion;
import io.skylite.jobs.JobExecutionContext;
import io.skylite.jobs.ScheduledJobParameter;
import io.skylite.jobs.ScheduledJobParser;
import io.skylite.jobs.ScheduledJobRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.extensions.action.ExtensionProxyAction;

public class JobDetailsService
implements IndexingOperationListener {
    private static final Logger logger = LogManager.getLogger(JobDetailsService.class);
    public static final String JOB_DETAILS_INDEX_NAME = ".lucenia-job-scheduler-job-details";
    private static final String PLUGINS_JOB_DETAILS_MAPPING_FILE = "/mappings/lucenia_job_scheduler_job_details.json";
    public static Long TIME_OUT_FOR_REQUEST = 15L;
    private final Client client;
    private final ClusterService clusterService;
    private Set<String> indicesToListen;
    private Map<String, ScheduledJobProvider> indexToJobProviders;
    private static final ConcurrentMap<String, JobDetails> indexToJobDetails = IndexToJobDetails.getInstance();

    public JobDetailsService(Client client, ClusterService clusterService, Set<String> indicesToListen, Map<String, ScheduledJobProvider> indexToJobProviders) {
        this.client = client;
        this.clusterService = clusterService;
        this.indicesToListen = indicesToListen;
        this.indexToJobProviders = indexToJobProviders;
    }

    public static ConcurrentMap<String, JobDetails> getIndexToJobDetails() {
        return indexToJobDetails;
    }

    public Map<String, ScheduledJobProvider> getIndexToJobProviders() {
        return this.indexToJobProviders;
    }

    public boolean jobDetailsIndexExist() {
        return this.clusterService.state().routingTable().hasIndex(JOB_DETAILS_INDEX_NAME);
    }

    private void updateIndicesToListen(String jobIndexName) {
        this.indicesToListen.add(jobIndexName);
    }

    void updateIndexToJobProviders(String documentId, JobDetails jobDetails) {
        String extensionJobIndex = jobDetails.getJobIndex();
        String extensionJobType = jobDetails.getJobType();
        String extensionUniqueId = jobDetails.getExtensionUniqueId();
        ScheduledJobParser extensionJobParser = this.createProxyScheduledJobParser(extensionUniqueId, jobDetails.getJobParameterAction());
        ScheduledJobRunner extensionJobRunner = this.createProxyScheduledJobRunner(documentId, extensionUniqueId, jobDetails.getJobRunnerAction());
        this.indexToJobProviders.put(extensionJobIndex, new ScheduledJobProvider(extensionJobType, extensionJobIndex, extensionJobParser, extensionJobRunner));
    }

    void updateIndexToJobDetails(String documentId, JobDetails jobDetails) {
        indexToJobDetails.put(documentId, jobDetails);
        this.updateIndicesToListen(jobDetails.getJobIndex());
        this.updateIndexToJobProviders(documentId, jobDetails);
    }

    private ScheduledJobParser createProxyScheduledJobParser(final String extensionUniqueId, final String extensionJobParameterAction) {
        return new ScheduledJobParser(){

            public ScheduledJobParameter parse(XContentParser xContentParser, String id, JobDocVersion jobDocVersion) throws IOException {
                logger.info("Sending ScheduledJobParameter parse request to extension : " + extensionUniqueId);
                ExtensionJobParameter[] extensionJobParameterHolder = new ExtensionJobParameter[1];
                CompletableFuture inProgressFuture = new CompletableFuture();
                JobParameterRequest jobParamRequest = new JobParameterRequest("placeholder", xContentParser, id, jobDocVersion);
                JobDetailsService.this.client.execute((ActionType)ExtensionProxyAction.INSTANCE, new ExtensionJobActionRequest<JobParameterRequest>(extensionJobParameterAction, jobParamRequest), ActionListenerHelper.wrap(response -> {
                    JobParameterResponse jobParameterResponse = new JobParameterResponse(response.getResponseBytes());
                    extensionJobParameterHolder[0] = jobParameterResponse.getJobParameter();
                    inProgressFuture.complete(extensionJobParameterHolder);
                }, exception -> {
                    logger.error("Could not parse job parameter", (Throwable)exception);
                    inProgressFuture.completeExceptionally((Throwable)exception);
                }));
                try {
                    inProgressFuture.orTimeout(TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).join();
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof TimeoutException) {
                        logger.error("Request timed out with an exception ", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not parse ScheduledJobParameter due to exception ", (Throwable)e);
                }
                return extensionJobParameterHolder[0];
            }
        };
    }

    private ScheduledJobRunner createProxyScheduledJobRunner(final String documentId, final String extensionUniqueId, final String extensionJobRunnerAction) {
        return new ScheduledJobRunner(){

            public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
                logger.info("Sending ScheduledJobRunner runJob request to extension : " + extensionUniqueId);
                Boolean[] extensionJobRunnerStatus = new Boolean[1];
                CompletableFuture inProgressFuture = new CompletableFuture();
                try {
                    JobRunnerRequest jobRunnerRequest = new JobRunnerRequest("placeholder", documentId, context);
                    JobDetailsService.this.client.execute((ActionType)ExtensionProxyAction.INSTANCE, new ExtensionJobActionRequest<JobRunnerRequest>(extensionJobRunnerAction, jobRunnerRequest), ActionListenerHelper.wrap(response -> {
                        JobRunnerResponse jobRunnerResponse = new JobRunnerResponse(response.getResponseBytes());
                        extensionJobRunnerStatus[0] = jobRunnerResponse.getJobRunnerStatus();
                        inProgressFuture.complete(extensionJobRunnerStatus);
                    }, exception -> {
                        logger.error("Failed to run job due to exception ", (Throwable)exception);
                        inProgressFuture.completeExceptionally((Throwable)exception);
                    }));
                    inProgressFuture.orTimeout(TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).join();
                }
                catch (IOException e) {
                    logger.error("Failed to create JobRunnerRequest", (Throwable)e);
                }
                catch (CompletionException e) {
                    if (e.getCause() instanceof TimeoutException) {
                        logger.error("Request timed out with an exception ", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Could not run extension job due to exception ", (Throwable)e);
                }
                logger.info("Job Runner Status for extension " + extensionUniqueId + " : " + extensionJobRunnerStatus[0]);
            }
        };
    }

    public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
        if (result.getResultType().equals((Object)EngineResult.Type.FAILURE)) {
            logger.info("Job Details Registration failed for extension {} on index {}", (Object)index.id(), (Object)shardId.getIndexName());
            return;
        }
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, index.source().utf8ToString());
            parser.nextToken();
            this.updateIndexToJobDetails(index.id(), JobDetails.parse(parser));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating job details for extension id " + index.id(), (Throwable)e);
        }
    }

    void createJobDetailsIndex(ActionListener<Boolean> listener) {
        if (this.jobDetailsIndexExist()) {
            listener.onResponse((Object)true);
        } else {
            CreateIndexRequest request = new CreateIndexRequest(JOB_DETAILS_INDEX_NAME).mapping(this.jobDetailsMapping(), (MediaType)XContentType.JSON);
            this.client.admin().indices().create(request, ActionListenerHelper.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), exception -> {
                if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) {
                    listener.onResponse((Object)true);
                } else {
                    listener.onFailure(exception);
                }
            }));
        }
    }

    public void processJobDetails(String documentId, String jobIndexName, String jobTypeName, String jobParameterActionName, String jobRunnerActionName, String extensionUniqueId, ActionListener<String> listener) {
        if (jobIndexName == null || jobIndexName.isEmpty() || jobTypeName == null || jobTypeName.isEmpty() || jobParameterActionName == null || jobParameterActionName.isEmpty() || jobRunnerActionName == null || jobRunnerActionName.isEmpty() || extensionUniqueId == null || extensionUniqueId.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("JobIndexName, JobTypeName, JobParameterActionName, JobRunnerActionName, Extension Unique Id must not be null or empty"));
        } else {
            this.createJobDetailsIndex((ActionListener<Boolean>)ActionListenerHelper.wrap(created -> {
                block5: {
                    if (created.booleanValue()) {
                        try {
                            if (documentId != null) {
                                this.findJobDetails(documentId, (ActionListener<JobDetails>)ActionListenerHelper.wrap(existingJobDetails -> {
                                    JobDetails updateJobDetails = new JobDetails((JobDetails)existingJobDetails);
                                    updateJobDetails.setJobIndex(jobIndexName);
                                    updateJobDetails.setJobType(jobTypeName);
                                    updateJobDetails.setJobParameterAction(jobParameterActionName);
                                    updateJobDetails.setJobRunnerAction(jobRunnerActionName);
                                    this.updateJobDetails(documentId, updateJobDetails, listener);
                                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                                break block5;
                            }
                            JobDetails tempJobDetails = new JobDetails(jobIndexName, jobTypeName, jobParameterActionName, jobRunnerActionName, extensionUniqueId);
                            logger.info("Creating job details for extension unique id " + extensionUniqueId + " : " + String.valueOf(tempJobDetails));
                            this.createJobDetails(tempJobDetails, listener);
                        }
                        catch (VersionConflictEngineException e) {
                            logger.debug("could not process job index for extensionUniqueId [{}]: {}", (Object)extensionUniqueId, (Object)e.getMessage());
                            listener.onResponse(null);
                        }
                    } else {
                        listener.onResponse(null);
                    }
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void createJobDetails(JobDetails tempJobDetails, ActionListener<String> listener) {
        try {
            IndexRequest request = new IndexRequest(JOB_DETAILS_INDEX_NAME).source(tempJobDetails.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setIfSeqNo(-2L).setIfPrimaryTerm(0L).create(true);
            this.client.index(request, ActionListenerHelper.wrap(response -> listener.onResponse((Object)response.getId()), exception -> {
                if (exception instanceof IOException) {
                    logger.error("IOException occurred creating job details", (Throwable)exception);
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating job details", (Throwable)e);
            listener.onResponse(null);
        }
    }

    private void findJobDetails(String documentId, ActionListener<JobDetails> listener) {
        GetRequest getRequest = new GetRequest(JOB_DETAILS_INDEX_NAME).id(documentId);
        this.client.get(getRequest, ActionListenerHelper.wrap(response -> {
            if (!response.isExists()) {
                listener.onResponse(null);
            } else {
                try {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
                    parser.nextToken();
                    listener.onResponse((Object)JobDetails.parse(parser));
                }
                catch (IOException e) {
                    logger.error("IOException occurred finding JobDetails for documentId " + documentId, (Throwable)e);
                    listener.onResponse(null);
                }
            }
        }, exception -> {
            logger.error("Exception occurred finding job details for documentId " + documentId, (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    public void deleteJobDetails(String documentId, ActionListener<Boolean> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(JOB_DETAILS_INDEX_NAME).id(documentId);
        this.client.delete(deleteRequest, ActionListenerHelper.wrap(response -> listener.onResponse((Object)(response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND ? 1 : 0)), exception -> {
            if (exception instanceof IndexNotFoundException || exception.getCause() instanceof IndexNotFoundException) {
                logger.debug("Index is not found to delete job details for document id. [{}]: {}", (Object)documentId, (Object)exception.getMessage());
                listener.onResponse((Object)true);
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    private void updateJobDetails(String documentId, JobDetails updateJobDetails, ActionListener<String> listener) {
        try {
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(JOB_DETAILS_INDEX_NAME)).id(documentId).doc(updateJobDetails.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).fetchSource(true);
            this.client.update(updateRequest, ActionListenerHelper.wrap(response -> listener.onResponse((Object)response.getId()), exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    throw new RuntimeException("could not update job details for documentId [" + documentId + "]: " + exception.getMessage());
                }
                if (exception instanceof DocumentMissingException) {
                    throw new RuntimeException("Document is deleted. This happens if the job details are already removed: " + exception.getMessage());
                }
                if (exception instanceof IOException) {
                    throw new RuntimeException("IOException occurred in update job details: " + exception.getMessage());
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred updating job details for documentId " + documentId, (Throwable)e);
            listener.onResponse(null);
        }
    }

    private String jobDetailsMapping() {
        try {
            String line;
            InputStream in = JobDetailsService.class.getResourceAsStream(PLUGINS_JOB_DETAILS_MAPPING_FILE);
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JobDetails Mapping cannot be read correctly.");
        }
    }

    private static class IndexToJobDetails {
        private static final ConcurrentMap<String, JobDetails> indexToJobDetails = new ConcurrentHashMap<String, JobDetails>();

        private IndexToJobDetails() {
        }

        public static ConcurrentMap<String, JobDetails> getInstance() {
            return indexToJobDetails;
        }
    }
}

