/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.fm;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.LinkedHashMap;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.ONNXExportable;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.sgd.protos.FMClassificationModelProto;
import org.tribuo.common.sgd.AbstractFMModel;
import org.tribuo.common.sgd.AbstractSGDModel;
import org.tribuo.common.sgd.FMParameters;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.math.Parameters;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.protos.NormalizerProto;
import org.tribuo.math.protos.ParametersProto;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.util.onnx.ONNXNode;

public class FMClassificationModel
extends AbstractFMModel<Label>
implements ONNXExportable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    private final VectorNormalizer normalizer;

    FMClassificationModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Label> outputIDInfo, FMParameters parameters, VectorNormalizer normalizer, boolean generatesProbabilities) {
        super(name, provenance, featureIDMap, outputIDInfo, parameters, generatesProbabilities);
        this.normalizer = normalizer;
    }

    public static FMClassificationModel deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        FMClassificationModelProto proto = (FMClassificationModelProto)message.unpack(FMClassificationModelProto.class);
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(Label.class)) {
            throw new IllegalStateException("Invalid protobuf, output domain is not a label domain, found " + carrier.outputDomain().getClass());
        }
        ImmutableOutputInfo outputDomain = carrier.outputDomain();
        Parameters params = Parameters.deserialize((ParametersProto)proto.getParams());
        if (!(params instanceof FMParameters)) {
            throw new IllegalStateException("Invalid protobuf, parameters must be FMParameters, found " + params.getClass());
        }
        VectorNormalizer normalizer = VectorNormalizer.deserialize((NormalizerProto)proto.getNormalizer());
        return new FMClassificationModel(carrier.name(), carrier.provenance(), carrier.featureDomain(), (ImmutableOutputInfo<Label>)outputDomain, (FMParameters)params, normalizer, carrier.generatesProbabilities());
    }

    public Prediction<Label> predict(Example<Label> example) {
        AbstractSGDModel.PredAndActive predTuple = this.predictSingle(example);
        DenseVector prediction = predTuple.prediction;
        prediction.normalize(this.normalizer);
        double maxScore = Double.NEGATIVE_INFINITY;
        Label maxLabel = null;
        LinkedHashMap<String, Label> predMap = new LinkedHashMap<String, Label>();
        for (int i = 0; i < prediction.size(); ++i) {
            String labelName = ((Label)this.outputIDInfo.getOutput(i)).getLabel();
            double score = prediction.get(i);
            Label label = new Label(labelName, score);
            predMap.put(labelName, label);
            if (!(score > maxScore)) continue;
            maxScore = score;
            maxLabel = label;
        }
        return new Prediction(maxLabel, predMap, predTuple.numActiveFeatures, example, this.generatesProbabilities);
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        FMClassificationModelProto.Builder modelBuilder = FMClassificationModelProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setParams((ParametersProto)this.modelParameters.serialize());
        modelBuilder.setNormalizer((NormalizerProto)this.normalizer.serialize());
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(FMClassificationModel.class.getName());
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        return builder.build();
    }

    protected FMClassificationModel copy(String newName, ModelProvenance newProvenance) {
        return new FMClassificationModel(newName, newProvenance, this.featureIDMap, (ImmutableOutputInfo<Label>)this.outputIDInfo, (FMParameters)this.modelParameters.copy(), this.normalizer, this.generatesProbabilities);
    }

    protected String getDimensionName(int index) {
        return ((Label)this.outputIDInfo.getOutput(index)).getLabel();
    }

    protected String onnxModelName() {
        return "FMClassificationModel";
    }

    protected ONNXNode onnxOutput(ONNXNode input) {
        return this.normalizer.exportNormalizer(input);
    }
}

