/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class AbstractStringProcessor<T>
extends AbstractProcessor
implements IngestProcessor {
    private final String field;
    private final boolean ignoreMissing;
    private final String targetField;

    AbstractStringProcessor(String tag, String description, boolean ignoreMissing, String targetField, String field) {
        super(tag, description);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.targetField = targetField;
    }

    public String getField() {
        return this.field;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getTargetField() {
        return this.targetField;
    }

    public final IngestDocument execute(IngestDocument document) {
        Object newValue;
        Object val = document.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (val == null && this.ignoreMissing) {
            return document;
        }
        if (val == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        if (val instanceof List) {
            List list = (List)val;
            ArrayList<T> newList = new ArrayList<T>(list.size());
            for (Object value : list) {
                if (value instanceof String) {
                    newList.add(this.process((String)value));
                    continue;
                }
                throw new IllegalArgumentException("value [" + String.valueOf(value) + "] of type [" + value.getClass().getName() + "] in list field [" + this.field + "] cannot be cast to [" + String.class.getName() + "]");
            }
            newValue = newList;
        } else if (val instanceof String) {
            newValue = this.process((String)val);
        } else {
            throw new IllegalArgumentException("field [" + this.field + "] of type [" + val.getClass().getName() + "] cannot be cast to [" + String.class.getName() + "]");
        }
        document.setFieldValue(this.targetField, newValue);
        return document;
    }

    protected abstract T process(String var1);

    static abstract class Factory
    implements AbstractProcessor.Factory<AbstractStringProcessor<?>> {
        final String processorType;

        protected Factory(String processorType) {
            this.processorType = processorType;
        }

        public AbstractStringProcessor<?> create(Map<String, AbstractProcessor.Factory<?>> registry, String tag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)this.processorType, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)this.processorType, (String)tag, config, (String)"ignore_missing", (boolean)false);
            String targetField = ConfigurationUtils.readStringProperty((String)this.processorType, (String)tag, config, (String)"target_field", (String)field);
            return this.newProcessor(tag, description, config, field, ignoreMissing, targetField);
        }

        protected abstract AbstractStringProcessor<?> newProcessor(String var1, String var2, Map<String, Object> var3, String var4, boolean var5, String var6);
    }
}

