/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.lucenia.ingest.common.AbstractStringProcessor;
import io.skylite.core.common.unit.ByteSizeValue;
import java.util.Map;

public final class BytesProcessor
extends AbstractStringProcessor<Long> {
    public static final String TYPE = "bytes";

    BytesProcessor(String processorTag, String description, String field, boolean ignoreMissing, String targetField) {
        super(processorTag, description, ignoreMissing, targetField, field);
    }

    public static long apply(String value) {
        return ByteSizeValue.parseBytesSizeValue((String)value, null, (String)"Ingest Field").getBytes();
    }

    @Override
    protected Long process(String value) {
        return BytesProcessor.apply(value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(BytesProcessor.TYPE);
        }

        protected BytesProcessor newProcessor(String tag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new BytesProcessor(tag, description, field, ignoreMissing, targetField);
        }
    }
}

