/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.dissect.DissectParser;
import java.util.Map;

public final class DissectProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "dissect";
    final String field;
    final boolean ignoreMissing;
    final String pattern;
    final String appendSeparator;
    final DissectParser dissectParser;

    DissectProcessor(String tag, String description, String field, String pattern, String appendSeparator, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.pattern = pattern;
        this.appendSeparator = appendSeparator;
        this.dissectParser = new DissectParser(pattern, appendSeparator);
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        String input = (String)ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (input == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (input == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        this.dissectParser.parse(input).forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<DissectProcessor> {
        public DissectProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"field");
            String pattern = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"pattern");
            String appendSeparator = ConfigurationUtils.readStringProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"append_separator", (String)"");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)DissectProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new DissectProcessor(processorTag, description, field, pattern, appendSeparator, ignoreMissing);
        }
    }
}

