/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.common.Strings;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RemoveProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "remove";
    private final List<TemplateScript.Factory> fields;
    private final boolean ignoreMissing;

    RemoveProcessor(String tag, String description, List<TemplateScript.Factory> fields, boolean ignoreMissing) {
        super(tag, description);
        this.fields = new ArrayList<TemplateScript.Factory>(fields);
        this.ignoreMissing = ignoreMissing;
    }

    public List<TemplateScript.Factory> getFields() {
        return this.fields;
    }

    public IngestDocument execute(IngestDocument document) {
        this.fields.forEach(field -> {
            String path = document.renderTemplate(field);
            boolean fieldPathIsNullOrEmpty = Strings.isNullOrEmpty((String)path);
            if (fieldPathIsNullOrEmpty || !document.hasField(path)) {
                if (this.ignoreMissing) {
                    return;
                }
                if (fieldPathIsNullOrEmpty) {
                    throw new IllegalArgumentException("field path cannot be null nor empty");
                }
                throw new IllegalArgumentException("field [" + path + "] doesn't exist");
            }
            document.removeField(path);
        });
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<RemoveProcessor> {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public RemoveProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            ArrayList<String> fields = new ArrayList<String>();
            Object field = ConfigurationUtils.readObject((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"field");
            if (field instanceof List) {
                List stringList = (List)field;
                fields.addAll(stringList);
            } else {
                fields.add((String)field);
            }
            List<TemplateScript.Factory> compiledTemplates = fields.stream().map(f -> ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)f, (ScriptService)this.scriptService)).collect(Collectors.toList());
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new RemoveProcessor(processorTag, description, compiledTemplates, ignoreMissing);
        }
    }
}

