/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.common.Strings;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import java.util.Map;

public final class RenameProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "rename";
    private final TemplateScript.Factory field;
    private final TemplateScript.Factory targetField;
    private final boolean ignoreMissing;

    RenameProcessor(String tag, String description, TemplateScript.Factory field, TemplateScript.Factory targetField, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    TemplateScript.Factory getField() {
        return this.field;
    }

    TemplateScript.Factory getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) {
        String path = document.renderTemplate(this.field);
        boolean fieldPathIsNullOrEmpty = Strings.isNullOrEmpty((String)path);
        if (fieldPathIsNullOrEmpty || !document.hasField(path, true)) {
            if (this.ignoreMissing) {
                return document;
            }
            if (fieldPathIsNullOrEmpty) {
                throw new IllegalArgumentException("field path cannot be null nor empty");
            }
            throw new IllegalArgumentException("field [" + path + "] doesn't exist");
        }
        String target = document.renderTemplate(this.targetField);
        if (document.hasField(target, true)) {
            throw new IllegalArgumentException("field [" + target + "] already exists");
        }
        Object value = document.getFieldValue(path, Object.class);
        document.removeField(path);
        try {
            document.setFieldValue(target, value);
        }
        catch (Exception e) {
            document.setFieldValue(path, value);
            throw e;
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<RenameProcessor> {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public RenameProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"field");
            TemplateScript.Factory fieldTemplate = ConfigurationUtils.compileTemplate((String)RenameProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            String targetField = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            TemplateScript.Factory targetFieldTemplate = ConfigurationUtils.compileTemplate((String)RenameProcessor.TYPE, (String)processorTag, (String)"target_field", (String)targetField, (ScriptService)this.scriptService);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new RenameProcessor(processorTag, description, fieldTemplate, targetFieldTemplate, ignoreMissing);
        }
    }
}

