/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.common;

import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.ingest.ValueSource;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import java.util.Map;

public final class SetProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "set";
    private final boolean overrideEnabled;
    private final TemplateScript.Factory field;
    private final ValueSource value;
    private final boolean ignoreEmptyValue;

    SetProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value) {
        this(tag, description, field, value, true, false);
    }

    SetProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, boolean overrideEnabled, boolean ignoreEmptyValue) {
        super(tag, description);
        this.overrideEnabled = overrideEnabled;
        this.field = field;
        this.value = value;
        this.ignoreEmptyValue = ignoreEmptyValue;
    }

    public boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public boolean isIgnoreEmptyValue() {
        return this.ignoreEmptyValue;
    }

    public IngestDocument execute(IngestDocument document) {
        if (this.overrideEnabled || !document.hasField(this.field) || document.getFieldValue(this.field, Object.class) == null) {
            document.setFieldValue(this.field, this.value, this.ignoreEmptyValue);
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<SetProcessor> {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public SetProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"field");
            Object value = ConfigurationUtils.readObject((String)SetProcessor.TYPE, (String)processorTag, config, (String)"value");
            boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"override", (boolean)true);
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate((String)SetProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            boolean ignoreEmptyValue = ConfigurationUtils.readBooleanProperty((String)SetProcessor.TYPE, (String)processorTag, config, (String)"ignore_empty_value", (boolean)false);
            return new SetProcessor(processorTag, description, compiledTemplate, ValueSource.wrap((Object)value, (ScriptService)this.scriptService), overrideEnabled, ignoreEmptyValue);
        }
    }
}

