/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap;

import com.amazon.dlic.auth.ldap.util.Utils;
import io.lucenia.security.support.WildcardMatcher;
import io.lucenia.security.user.AuthCredentials;
import io.lucenia.security.user.User;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;

public class LdapUser
extends User {
    private static final long serialVersionUID = 1L;
    private final transient LdapEntry userEntry;
    private final String originalUsername;

    public LdapUser(String name, String originalUsername, LdapEntry userEntry, AuthCredentials credentials, int customAttrMaxValueLen, WildcardMatcher allowlistedCustomLdapAttrMatcher) {
        super(name, null, credentials);
        this.originalUsername = originalUsername;
        this.userEntry = userEntry;
        Map<String, String> attributes = this.getCustomAttributesMap();
        attributes.putAll(LdapUser.extractLdapAttributes(originalUsername, userEntry, customAttrMaxValueLen, allowlistedCustomLdapAttrMatcher));
    }

    public LdapUser(StreamInput in) throws IOException {
        super(in);
        this.userEntry = null;
        this.originalUsername = in.readString();
    }

    public LdapEntry getUserEntry() {
        return this.userEntry;
    }

    public String getDn() {
        return this.userEntry.getDn();
    }

    public String getOriginalUsername() {
        return this.originalUsername;
    }

    public static Map<String, String> extractLdapAttributes(String originalUsername, LdapEntry userEntry, int customAttrMaxValueLen, WildcardMatcher allowlistedCustomLdapAttrMatcher) {
        HashMap<Object, String> attributes = new HashMap<Object, String>();
        attributes.put("ldap.original.username", originalUsername);
        attributes.put("ldap.dn", userEntry.getDn());
        if (customAttrMaxValueLen > 0) {
            for (LdapAttribute attr : userEntry.getAttributes()) {
                String val;
                if (attr == null || attr.isBinary() || attr.getName().toLowerCase().contains("password") || (val = Utils.getSingleStringValue(attr)) == null || val.length() <= 0 || val.length() > customAttrMaxValueLen || !allowlistedCustomLdapAttrMatcher.test(attr.getName())) continue;
                attributes.put("attr.ldap." + attr.getName(), val);
            }
        }
        return Collections.unmodifiableMap(attributes);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.originalUsername);
    }
}

