/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap2;

import io.netty.util.internal.PlatformDependent;
import io.skylite.SpecialPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;

public class MakeJava9Happy {
    private static ClassLoader classLoader;
    private static boolean isJava9OrHigher;
    private static final Class threadLocalTLSSocketFactoryClass;

    static ClassLoader getClassLoader() {
        if (!isJava9OrHigher) {
            return null;
        }
        if (classLoader == null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return new Java9CL();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getException();
                }
                throw new RuntimeException(e);
            }
        }
        return classLoader;
    }

    static {
        isJava9OrHigher = PlatformDependent.javaVersion() >= 9;
        threadLocalTLSSocketFactoryClass = ThreadLocalTLSSocketFactory.class;
    }

    private static final class Java9CL
    extends ClassLoader {
        public Java9CL() {
        }

        public Java9CL(ClassLoader parent) {
            super(parent);
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            if (!name.equalsIgnoreCase("org.ldaptive.ssl.ThreadLocalTLSSocketFactory")) {
                return super.loadClass(name);
            }
            return threadLocalTLSSocketFactoryClass;
        }
    }
}

