/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap2;

import io.skylite.SpecialPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Response;
import org.ldaptive.SearchRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.jndi.JndiProviderConfig;

public class PrivilegedProvider
implements Provider<JndiProviderConfig> {
    private final Provider<JndiProviderConfig> delegate;

    public PrivilegedProvider(Provider<JndiProviderConfig> delegate) {
        this.delegate = delegate;
    }

    public JndiProviderConfig getProviderConfig() {
        return (JndiProviderConfig)this.delegate.getProviderConfig();
    }

    public void setProviderConfig(JndiProviderConfig pc) {
        this.delegate.setProviderConfig((ProviderConfig)pc);
    }

    public ProviderConnectionFactory<JndiProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        ProviderConnectionFactory connectionFactory = this.delegate.getConnectionFactory(cc);
        return new PrivilegedProviderConnectionFactory((ProviderConnectionFactory<JndiProviderConfig>)connectionFactory);
    }

    public Provider<JndiProviderConfig> newInstance() {
        return new PrivilegedProvider((Provider<JndiProviderConfig>)this.delegate.newInstance());
    }

    private static class PrivilegedProviderConnectionFactory
    implements ProviderConnectionFactory<JndiProviderConfig> {
        private final ProviderConnectionFactory<JndiProviderConfig> delegate;

        PrivilegedProviderConnectionFactory(ProviderConnectionFactory<JndiProviderConfig> delegate) {
            this.delegate = delegate;
        }

        public JndiProviderConfig getProviderConfig() {
            return (JndiProviderConfig)this.delegate.getProviderConfig();
        }

        public ProviderConnection create() throws LdapException {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ProviderConnection>(){

                    @Override
                    public ProviderConnection run() throws Exception {
                        return new PrivilegedProviderConnection(delegate.create(), this.getProviderConfig());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof LdapException) {
                    throw (LdapException)((Object)e.getException());
                }
                if (e.getException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }
    }

    private static class PrivilegedProviderConnection
    implements ProviderConnection {
        private final ProviderConnection delegate;
        private final JndiProviderConfig jndiProviderConfig;

        public PrivilegedProviderConnection(ProviderConnection delegate, JndiProviderConfig jndiProviderConfig) {
            this.delegate = delegate;
            this.jndiProviderConfig = jndiProviderConfig;
        }

        public Response<Void> bind(final BindRequest request) throws LdapException {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Response<Void>>(){

                    @Override
                    public Response<Void> run() throws Exception {
                        if (jndiProviderConfig.getClassLoader() != null) {
                            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(jndiProviderConfig.getClassLoader());
                                Response response = delegate.bind(request);
                                return response;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(originalClassLoader);
                            }
                        }
                        return delegate.bind(request);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof LdapException) {
                    throw (LdapException)((Object)e.getException());
                }
                if (e.getException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }

        public Response<Void> add(AddRequest request) throws LdapException {
            return this.delegate.add(request);
        }

        public Response<Boolean> compare(CompareRequest request) throws LdapException {
            return this.delegate.compare(request);
        }

        public Response<Void> delete(DeleteRequest request) throws LdapException {
            return this.delegate.delete(request);
        }

        public Response<Void> modify(ModifyRequest request) throws LdapException {
            return this.delegate.modify(request);
        }

        public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
            return this.delegate.modifyDn(request);
        }

        public SearchIterator search(SearchRequest request) throws LdapException {
            return this.delegate.search(request);
        }

        public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
            this.delegate.searchAsync(request, listener);
        }

        public void abandon(int messageId, RequestControl[] controls) throws LdapException {
            this.delegate.abandon(messageId, controls);
        }

        public Response<?> extendedOperation(ExtendedRequest request) throws LdapException {
            return this.delegate.extendedOperation(request);
        }

        public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.delegate.addUnsolicitedNotificationListener(listener);
        }

        public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            this.delegate.removeUnsolicitedNotificationListener(listener);
        }

        public void close(RequestControl[] controls) throws LdapException {
            this.delegate.close(controls);
        }
    }
}

