/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auditlog.impl;

import io.lucenia.security.auditlog.config.AuditConfig;
import io.lucenia.security.auditlog.impl.AbstractAuditLog;
import io.lucenia.security.auditlog.impl.AuditMessage;
import io.lucenia.security.auditlog.routing.AuditMessageRouter;
import io.lucenia.security.filter.SecurityRequest;
import io.skylite.SpecialPermission;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.env.Environment;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Map;
import org.greenrobot.eventbus.Subscribe;

public final class AuditLogImpl
extends AbstractAuditLog {
    private final AuditMessageRouter messageRouter;
    private final Settings settings;
    private final boolean messageRouterEnabled;
    private volatile boolean enabled;
    private final Thread shutdownHook;

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        this(settings, configPath, clientProvider, threadPool, resolver, clusterService, null);
    }

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, Environment environment) {
        super(settings, threadPool, resolver, clusterService, environment);
        this.settings = settings;
        this.messageRouter = new AuditMessageRouter(settings, clientProvider, threadPool, configPath);
        this.messageRouterEnabled = this.messageRouter.isEnabled();
        this.log.info("Message routing enabled: {}", (Object)this.messageRouterEnabled);
        SpecialPermission.check();
        this.shutdownHook = AccessController.doPrivileged(this::addShutdownHook);
        this.log.debug("Shutdown hook {} registered", (Object)this.shutdownHook);
    }

    @Override
    @Subscribe
    public void setConfig(AuditConfig auditConfig) {
        this.enabled = auditConfig.isEnabled() && this.messageRouterEnabled;
        this.onAuditConfigFilterChanged(auditConfig.getFilter());
        this.onComplianceConfigChanged(auditConfig.getCompliance());
    }

    @Override
    protected void enableRoutes() {
        if (this.messageRouterEnabled) {
            this.messageRouter.enableRoutes(this.settings);
        }
    }

    private Thread addShutdownHook() {
        Thread shutdownHook = new Thread(() -> this.messageRouter.close());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    private Boolean removeShutdownHook() {
        return Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    @Override
    public void close() throws IOException {
        this.log.info("Closing {}", (Object)this.getClass().getSimpleName());
        SpecialPermission.check();
        try {
            boolean removed = AccessController.doPrivileged(this::removeShutdownHook);
            if (removed) {
                this.log.debug("Shutdown hook {} unregistered", (Object)this.shutdownHook);
                this.shutdownHook.run();
            } else {
                this.log.warn("Shutdown hook {} is not registered", (Object)this.shutdownHook);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug("Fail to unregister shutdown hook {}. Shutdown is in progress.", (Object)this.shutdownHook, (Object)e);
        }
    }

    @Override
    protected void save(AuditMessage msg) {
        if (this.enabled) {
            this.messageRouter.route(msg);
        }
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, SecurityRequest request) {
        if (this.enabled) {
            super.logFailedLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, SecurityRequest request) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, String effectiveUser, SecurityRequest request) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, effectiveUser, request);
        }
    }

    @Override
    public void logGrantedPrivileges(String effectiveUser, SecurityRequest request) {
        if (this.enabled) {
            super.logGrantedPrivileges(effectiveUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logGrantedPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logIndexEvent(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logIndexEvent(privilege, request, task);
        }
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logBadHeaders(request, action, task);
        }
    }

    @Override
    public void logBadHeaders(SecurityRequest request) {
        if (this.enabled) {
            super.logBadHeaders(request);
        }
    }

    @Override
    public void logSecurityIndexAttempt(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSecurityIndexAttempt(request, action, task);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (this.enabled) {
            super.logSSLException(request, t, action, task);
        }
    }

    @Override
    public void logSSLException(SecurityRequest request, Throwable t) {
        if (this.enabled) {
            super.logSSLException(request, t);
        }
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        if (this.enabled) {
            super.logDocumentRead(index, id, shardId, fieldNameValues);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, EngineOperation.Index currentIndex, EngineResult.IndexResult result) {
        if (this.enabled) {
            super.logDocumentWritten(shardId, originalResult, currentIndex, result);
        }
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
        if (this.enabled) {
            super.logDocumentDeleted(shardId, delete, result);
        }
    }

    @Override
    protected void logExternalConfig() {
        if (this.enabled) {
            super.logExternalConfig();
        }
    }
}

