/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auditlog.sink;

import io.lucenia.security.auditlog.impl.AuditMessage;
import io.lucenia.security.auditlog.sink.AuditLogSink;
import io.lucenia.security.support.HeaderHelper;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequestBuilder;
import io.skylite.core.client.Client;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.file.Path;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class InternalLuceniaSink
extends AuditLogSink {
    private final Client clientProvider;
    final String index;
    final String type;
    private DateTimeFormatter indexPattern;
    private final ThreadPool threadPool;

    public InternalLuceniaSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.clientProvider = clientProvider;
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.index = sinkSettings.get("index", "'security-auditlog-'YYYY.MM.dd");
        this.type = sinkSettings.get("type", null);
        this.threadPool = threadPool;
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (Boolean.parseBoolean(HeaderHelper.getSafeFromHeader(this.threadPool.getThreadContext(), "_opendistro_security_conf_request"))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("audit log of audit log will not be executed");
            }
            return true;
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            IndexRequestBuilder irb = ((IndexRequestBuilder)this.clientProvider.prepareIndex(this.getExpandedIndexName(this.indexPattern, this.index)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(msg.getAsMap());
            this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
            irb.setTimeout(TimeValue.timeValueMinutes((long)1L));
            irb.execute().actionGet();
            boolean bl = true;
            return bl;
        }
    }
}

