/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.auditlog.sink;

import io.lucenia.security.auditlog.impl.AuditMessage;
import io.lucenia.security.auditlog.sink.AuditLogSink;
import io.lucenia.security.ssl.SecureSSLSettings;
import io.lucenia.security.support.PemKeyReader;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;

public class WebhookSink
extends AuditLogSink {
    private final CloseableHttpClient httpClient;
    String webhookUrl = null;
    WebhookFormat webhookFormat = null;
    final boolean verifySSL;
    final KeyStore effectiveTruststore;

    public WebhookSink(String name, Settings settings, String settingsPrefix, Path configPath, AuditLogSink fallbackSink) throws Exception {
        super(name, settings, settingsPrefix, fallbackSink);
        Settings sinkSettings = settings.getAsSettings(settingsPrefix);
        this.effectiveTruststore = this.getEffectiveKeyStore(configPath);
        String webhookUrl = sinkSettings.get("webhook.url");
        String format = sinkSettings.get("webhook.format");
        this.verifySSL = sinkSettings.getAsBoolean("webhook.ssl.verify", Boolean.valueOf(true));
        this.httpClient = this.getHttpClient();
        if (this.httpClient == null) {
            this.log.error("Could not create HttpClient, audit log not available.");
            return;
        }
        if (Strings.isEmpty((CharSequence)webhookUrl)) {
            this.log.error("plugins.security.audit.config.webhook.url not provided, webhook audit log will not work");
            return;
        }
        try {
            new URL(webhookUrl);
            this.webhookUrl = webhookUrl;
        }
        catch (MalformedURLException ex) {
            this.log.error("URL {} is invalid, webhook audit log will not work.", (Object)webhookUrl, (Object)ex);
        }
        if (Strings.isEmpty((CharSequence)format)) {
            this.log.warn("plugins.security.audit.config.webhook.format not provided, falling back to 'text'");
            this.webhookFormat = WebhookFormat.TEXT;
        } else {
            try {
                this.webhookFormat = WebhookFormat.valueOf(format.toUpperCase());
            }
            catch (Exception ex) {
                this.log.error("Could not find WebhookFormat for type {}, falling back to 'text'", (Object)format, (Object)ex);
                this.webhookFormat = WebhookFormat.TEXT;
            }
        }
    }

    @Override
    public boolean doStore(final AuditMessage msg) {
        if (Strings.isEmpty((CharSequence)this.webhookUrl)) {
            this.log.debug("Webhook URL is null");
            return false;
        }
        if (msg == null) {
            this.log.debug("Message is null");
            return true;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean success = false;
                try {
                    switch (WebhookSink.this.webhookFormat.method.ordinal()) {
                        case 1: {
                            success = WebhookSink.this.post(msg);
                            break;
                        }
                        case 0: {
                            success = WebhookSink.this.get(msg);
                            break;
                        }
                        default: {
                            WebhookSink.this.log.error("Http Method '{}' defined in WebhookFormat '{}' not implemented yet", (Object)WebhookSink.this.webhookFormat.method.name(), (Object)WebhookSink.this.webhookFormat.name());
                        }
                    }
                    if (!success) {
                        WebhookSink.this.log.error(msg.toString());
                    }
                    return success;
                }
                catch (Throwable t) {
                    WebhookSink.this.log.error("Uncaught exception while trying to log message.", t);
                    WebhookSink.this.log.error(msg.toString());
                    return false;
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    protected String formatJson(AuditMessage msg) {
        return msg.toJson();
    }

    protected String formatText(AuditMessage msg) {
        return msg.toText();
    }

    protected String formatSlack(AuditMessage msg) {
        return "{\"text\": \"" + msg.toText() + "\"}";
    }

    protected String formatUrlParameters(AuditMessage msg) {
        return msg.toUrlParameters();
    }

    boolean get(AuditMessage msg) {
        switch (this.webhookFormat.ordinal()) {
            case 0: {
                return this.doGet(this.webhookUrl + this.formatUrlParameters(msg));
            }
        }
        this.log.error("WebhookFormat '{}' not implemented yet", (Object)this.webhookFormat.name());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse serverResponse = null;
        try {
            serverResponse = this.httpClient.execute((ClassicHttpRequest)httpGet);
            int responseCode = serverResponse.getCode();
            if (responseCode != 200) {
                this.log.error("Cannot GET to webhook URL '{}', server returned status {}", (Object)this.webhookUrl, (Object)responseCode);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.log.error("Cannot GET to webhook URL '{}'", (Object)this.webhookUrl, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (serverResponse != null) {
                    serverResponse.close();
                }
            }
            catch (IOException e) {
                this.log.error("Cannot close server response", (Throwable)e);
            }
        }
    }

    boolean post(AuditMessage msg) {
        Object payload;
        Object url = this.webhookUrl;
        switch (this.webhookFormat.ordinal()) {
            case 3: {
                payload = this.formatJson(msg);
                break;
            }
            case 2: {
                payload = this.formatText(msg);
                break;
            }
            case 4: {
                payload = "{\"text\": \"" + msg.toText() + "\"}";
                break;
            }
            case 1: {
                payload = "";
                url = this.webhookUrl + this.formatUrlParameters(msg);
                break;
            }
            default: {
                this.log.error("WebhookFormat '{}' not implemented yet", (Object)this.webhookFormat.name());
                return false;
            }
        }
        return this.doPost((String)url, (String)payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPost(String url, String payload) {
        HttpPost postRequest = new HttpPost(url);
        StringEntity input = new StringEntity(payload, this.webhookFormat.contentType.withCharset(StandardCharsets.UTF_8));
        postRequest.setEntity((HttpEntity)input);
        CloseableHttpResponse serverResponse = null;
        try {
            serverResponse = this.httpClient.execute((ClassicHttpRequest)postRequest);
            int responseCode = serverResponse.getCode();
            if (responseCode != 200) {
                this.log.error("Cannot POST to webhook URL '{}', server returned status {}", (Object)this.webhookUrl, (Object)responseCode);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.log.error("Cannot POST to webhook URL '{}' due to '{}'", (Object)this.webhookUrl, (Object)e.getMessage(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (serverResponse != null) {
                    serverResponse.close();
                }
            }
            catch (IOException e) {
                this.log.error("Cannot close server response", (Throwable)e);
            }
        }
    }

    private KeyStore getEffectiveKeyStore(final Path configPath) {
        return AccessController.doPrivileged(new PrivilegedAction<KeyStore>(){

            @Override
            public KeyStore run() {
                try {
                    boolean pem;
                    Settings sinkSettings = WebhookSink.this.settings.getAsSettings(WebhookSink.this.settingsPrefix);
                    boolean bl = pem = sinkSettings.get("webhook.ssl.pemtrustedcas_filepath", null) != null || sinkSettings.get("webhook.ssl.pemtrustedcas_content", null) != null;
                    if (pem) {
                        X509Certificate[] trustCertificates = PemKeyReader.loadCertificatesFromStream(PemKeyReader.resolveStream("webhook.ssl.pemtrustedcas_content", sinkSettings));
                        if (trustCertificates == null) {
                            String fullPath = WebhookSink.this.settingsPrefix + ".webhook.ssl.pemtrustedcas_filepath";
                            trustCertificates = PemKeyReader.loadCertificatesFromFile(PemKeyReader.resolve(fullPath, WebhookSink.this.settings, configPath, false));
                        }
                        return PemKeyReader.toTruststore("alw", trustCertificates);
                    }
                    return PemKeyReader.loadKeyStore(PemKeyReader.resolve("plugins.security.ssl.transport.truststore_filepath", WebhookSink.this.settings, configPath, false), SecureSSLSettings.SSLSetting.SECURITY_SSL_TRANSPORT_TRUSTSTORE_PASSWORD.getSetting(WebhookSink.this.settings), WebhookSink.this.settings.get("plugins.security.ssl.transport.truststore_type"));
                }
                catch (Exception ex) {
                    WebhookSink.this.log.error("Could not load key material. Make sure your certificates are located relative to the config directory", (Throwable)ex);
                    return null;
                }
            }
        });
    }

    CloseableHttpClient getHttpClient() {
        int timeout = 5;
        RequestConfig config = RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build();
        TrustStrategy trustAllStrategy = new TrustStrategy(this){

            public boolean isTrusted(X509Certificate[] chain, String authType) {
                return true;
            }
        };
        try {
            HttpClientBuilder hcb = HttpClients.custom().setDefaultRequestConfig(config);
            if (!this.verifySSL) {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(trustAllStrategy).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout, TimeUnit.SECONDS).build()).build();
                hcb.setConnectionManager((HttpClientConnectionManager)cm);
                return hcb.build();
            }
            if (this.effectiveTruststore == null) {
                return HttpClients.custom().setDefaultRequestConfig(config).build();
            }
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(this.effectiveTruststore, null).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, null, null, (HostnameVerifier)new DefaultHostnameVerifier());
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout, TimeUnit.SECONDS).build()).build();
            hcb.setConnectionManager((HttpClientConnectionManager)cm);
            return hcb.build();
        }
        catch (Exception ex) {
            this.log.error("Could not create HTTPClient due to {}, audit log not available.", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    public static enum WebhookFormat {
        URL_PARAMETER_GET(HttpMethod.GET, ContentType.TEXT_PLAIN),
        URL_PARAMETER_POST(HttpMethod.POST, ContentType.TEXT_PLAIN),
        TEXT(HttpMethod.POST, ContentType.TEXT_PLAIN),
        JSON(HttpMethod.POST, ContentType.APPLICATION_JSON),
        SLACK(HttpMethod.POST, ContentType.APPLICATION_JSON);

        private HttpMethod method;
        private ContentType contentType;

        private WebhookFormat(HttpMethod method, ContentType contentType) {
            this.method = method;
            this.contentType = contentType;
        }

        HttpMethod getMethod() {
            return this.method;
        }

        ContentType getContentType() {
            return this.contentType;
        }
    }

    private static enum HttpMethod {
        GET,
        POST;

    }
}

