/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.authtoken.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.util.ByteUtils;
import org.apache.commons.lang3.StringUtils;

public class KeyPaddingUtil {
    public static String padSecret(String signingKey, JWSAlgorithm jwsAlgorithm) {
        int requiredSecretLength;
        try {
            requiredSecretLength = MACSigner.getMinRequiredSecretLength((JWSAlgorithm)jwsAlgorithm);
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
        int requiredByteLength = ByteUtils.byteLength((int)requiredSecretLength);
        return StringUtils.rightPad((String)signingKey, (int)requiredByteLength, (String)"\u0000");
    }
}

