/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.compliance.ComplianceConfig;
import io.lucenia.security.compliance.FieldReadCallback;
import io.lucenia.security.configuration.MaskedField;
import io.lucenia.security.configuration.Salt;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.support.HeaderHelper;
import io.lucenia.security.support.MapUtils;
import io.lucenia.security.support.SecurityUtils;
import io.lucenia.security.support.WildcardMatcher;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.collect.Tuple;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.lucene.index.SequentialStoredFieldsLeafReader;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.opensearch.index.IndexService;

class DlsFlsFilterLeafReader
extends SequentialStoredFieldsLeafReader {
    private static final String KEYWORD = ".keyword";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Set<String> includesSet;
    private final Set<String> excludesSet;
    private final FieldInfos flsFieldInfos;
    private final boolean flsEnabled;
    private String[] includes;
    private String[] excludes;
    private boolean canOptimize = true;
    private Function<Map<String, ?>, Map<String, Object>> filterFunction;
    private final IndexService indexService;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AuditLog auditlog;
    private final MaskedFieldsMap maskedFieldsMap;
    private final ShardId shardId;
    private final boolean maskFields;
    private final Salt salt;
    private final String maskingAlgorithmDefault;
    private DlsGetEvaluator dge = null;
    private final MapUtils.Callback HASH_CB = new HashingCallback();

    DlsFlsFilterLeafReader(LeafReader delegate, Set<String> includesExcludes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, Set<String> maskedFields, ShardId shardId, Salt salt) {
        super(delegate);
        this.maskFields = maskedFields != null && maskedFields.size() > 0;
        this.indexService = indexService;
        this.threadContext = threadContext;
        this.clusterService = clusterService;
        this.auditlog = auditlog;
        this.salt = salt;
        this.maskingAlgorithmDefault = clusterService.getSettings().get("plugins.security.masked_fields.algorithm.default");
        this.maskedFieldsMap = MaskedFieldsMap.extractMaskedFields(this.maskFields, maskedFields, salt, this.maskingAlgorithmDefault);
        this.shardId = shardId;
        boolean bl = this.flsEnabled = includesExcludes != null && !includesExcludes.isEmpty();
        if (this.flsEnabled) {
            FieldInfos infos = delegate.getFieldInfos();
            this.includesSet = new HashSet<String>(includesExcludes.size());
            this.excludesSet = new HashSet<String>(includesExcludes.size());
            for (String incExc : includesExcludes) {
                char firstChar;
                if (this.canOptimize && (incExc.indexOf(46) > -1 || incExc.indexOf(42) > -1)) {
                    this.canOptimize = false;
                }
                if ((firstChar = incExc.charAt(0)) == '!' || firstChar == '~') {
                    this.excludesSet.add(incExc.substring(1));
                    this.excludesSet.add(incExc.substring(1) + KEYWORD);
                    continue;
                }
                this.includesSet.add(incExc);
            }
            int i = 0;
            FieldInfo[] fa = new FieldInfo[infos.size()];
            if (this.canOptimize) {
                if (!this.excludesSet.isEmpty()) {
                    for (FieldInfo info : infos) {
                        if (this.excludesSet.contains(info.name)) continue;
                        fa[i++] = info;
                    }
                } else {
                    for (String inc : this.includesSet) {
                        FieldInfo f = infos.fieldInfo(inc);
                        if (f == null) continue;
                        fa[i++] = f;
                    }
                }
            } else {
                if (!this.excludesSet.isEmpty()) {
                    matcher = WildcardMatcher.from(this.excludesSet);
                    for (FieldInfo info : infos) {
                        if (matcher.test(info.name)) continue;
                        fa[i++] = info;
                    }
                    this.excludes = this.excludesSet.toArray(EMPTY_STRING_ARRAY);
                } else {
                    matcher = WildcardMatcher.from(this.includesSet);
                    for (FieldInfo info : infos) {
                        if (!matcher.test(info.name)) continue;
                        fa[i++] = info;
                    }
                    this.includes = this.includesSet.toArray(EMPTY_STRING_ARRAY);
                }
                this.filterFunction = !this.excludesSet.isEmpty() ? XContentMapValuesUtil.filter(null, (String[])this.excludes) : XContentMapValuesUtil.filter((String[])this.includes, null);
            }
            FieldInfo[] tmp = new FieldInfo[i];
            System.arraycopy(fa, 0, tmp, 0, i);
            this.flsFieldInfos = new FieldInfos(tmp);
        } else {
            this.includesSet = null;
            this.excludesSet = null;
            this.flsFieldInfos = null;
        }
        try {
            this.dge = new DlsGetEvaluator(this, dlsQuery, this.in, this.applyDlsHere());
        }
        catch (IOException e) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return new DlsFlsStoredFieldsReader(reader);
    }

    private StoredFieldVisitor getDlsFlsVisitor(StoredFieldVisitor visitor) {
        ComplianceConfig complianceConfig = this.auditlog.getComplianceConfig();
        if (complianceConfig != null && complianceConfig.readHistoryEnabledForIndex(this.indexService.index().getName())) {
            visitor = new ComplianceAwareStoredFieldVisitor(visitor);
        }
        if (this.maskFields) {
            visitor = new HashingStoredFieldVisitor(visitor);
        }
        if (this.flsEnabled) {
            visitor = new FlsStoredFieldVisitor(visitor);
        }
        return visitor;
    }

    private void finishVisitor(StoredFieldVisitor visitor) {
        if (visitor instanceof FlsStoredFieldVisitor) {
            visitor = ((FlsStoredFieldVisitor)visitor).delegate;
        }
        if (visitor instanceof HashingStoredFieldVisitor) {
            visitor = ((HashingStoredFieldVisitor)visitor).delegate;
        }
        if (visitor instanceof ComplianceAwareStoredFieldVisitor) {
            ((ComplianceAwareStoredFieldVisitor)visitor).finished();
        }
    }

    private boolean isFls(BytesRef termAsFiledName) {
        return this.isFls(termAsFiledName.utf8ToString());
    }

    private boolean isFls(String name) {
        if (!this.flsEnabled) {
            return true;
        }
        return this.flsFieldInfos.fieldInfo(name) != null;
    }

    public FieldInfos getFieldInfos() {
        if (!this.flsEnabled) {
            return this.in.getFieldInfos();
        }
        return this.flsFieldInfos;
    }

    public TermVectors termVectors() throws IOException {
        return new TermVectors(){

            public Fields get(int doc) throws IOException {
                final Fields fields = DlsFlsFilterLeafReader.this.in.termVectors().get(doc);
                if (!DlsFlsFilterLeafReader.this.flsEnabled || fields == null) {
                    return fields;
                }
                return new Fields(){

                    public Iterator<String> iterator() {
                        return Iterators.filter((Iterator)fields.iterator(), input -> DlsFlsFilterLeafReader.this.isFls((String)input));
                    }

                    public Terms terms(String field) throws IOException {
                        if (!DlsFlsFilterLeafReader.this.isFls(field)) {
                            return null;
                        }
                        return DlsFlsFilterLeafReader.this.wrapTerms(field, DlsFlsFilterLeafReader.this.in.terms(field));
                    }

                    public int size() {
                        return DlsFlsFilterLeafReader.this.flsFieldInfos.size();
                    }
                };
            }
        };
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapBinaryDocValues(field, this.in.getBinaryDocValues(field)) : null;
    }

    private BinaryDocValues wrapBinaryDocValues(String field, final BinaryDocValues binaryDocValues) {
        MaskedField mf;
        MaskedFieldsMap maskedFieldsMap;
        if (binaryDocValues != null && (maskedFieldsMap = this.getRuntimeMaskedFieldInfo()) != null && (mf = (MaskedField)maskedFieldsMap.getMaskedField(this.handleKeyword(field)).orElse(null)) != null) {
            return new BinaryDocValues(this){

                public int nextDoc() throws IOException {
                    return binaryDocValues.nextDoc();
                }

                public int docID() {
                    return binaryDocValues.docID();
                }

                public long cost() {
                    return binaryDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return binaryDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return binaryDocValues.advanceExact(target);
                }

                public BytesRef binaryValue() throws IOException {
                    return mf.mask(binaryDocValues.binaryValue());
                }
            };
        }
        return binaryDocValues;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapSortedDocValues(field, this.in.getSortedDocValues(field)) : null;
    }

    private SortedDocValues wrapSortedDocValues(String field, final SortedDocValues sortedDocValues) {
        MaskedField mf;
        MaskedFieldsMap maskedFieldsMap;
        if (sortedDocValues != null && (maskedFieldsMap = this.getRuntimeMaskedFieldInfo()) != null && (mf = (MaskedField)maskedFieldsMap.getMaskedField(this.handleKeyword(field)).orElse(null)) != null) {
            return new SortedDocValues(this){

                public int lookupTerm(BytesRef key) throws IOException {
                    return sortedDocValues.lookupTerm(key);
                }

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(sortedDocValues.termsEnum(), mf);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(sortedDocValues.intersect(automaton), mf);
                }

                public int nextDoc() throws IOException {
                    return sortedDocValues.nextDoc();
                }

                public int docID() {
                    return sortedDocValues.docID();
                }

                public long cost() {
                    return sortedDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return sortedDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return sortedDocValues.advanceExact(target);
                }

                public int ordValue() throws IOException {
                    return sortedDocValues.ordValue();
                }

                public BytesRef lookupOrd(int ord) throws IOException {
                    return mf.mask(sortedDocValues.lookupOrd(ord));
                }

                public int getValueCount() {
                    return sortedDocValues.getValueCount();
                }
            };
        }
        return sortedDocValues;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapSortedSetDocValues(field, this.in.getSortedSetDocValues(field)) : null;
    }

    private SortedSetDocValues wrapSortedSetDocValues(String field, final SortedSetDocValues sortedSetDocValues) {
        MaskedField mf;
        MaskedFieldsMap maskedFieldsMap;
        if (sortedSetDocValues != null && (maskedFieldsMap = this.getRuntimeMaskedFieldInfo()) != null && (mf = (MaskedField)maskedFieldsMap.getMaskedField(this.handleKeyword(field)).orElse(null)) != null) {
            return new SortedSetDocValues(this){

                public long lookupTerm(BytesRef key) throws IOException {
                    return sortedSetDocValues.lookupTerm(key);
                }

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(sortedSetDocValues.termsEnum(), mf);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(sortedSetDocValues.intersect(automaton), mf);
                }

                public int nextDoc() throws IOException {
                    return sortedSetDocValues.nextDoc();
                }

                public int docID() {
                    return sortedSetDocValues.docID();
                }

                public long cost() {
                    return sortedSetDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return sortedSetDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return sortedSetDocValues.advanceExact(target);
                }

                public long nextOrd() throws IOException {
                    return sortedSetDocValues.nextOrd();
                }

                public int docValueCount() {
                    return sortedSetDocValues.docValueCount();
                }

                public BytesRef lookupOrd(long ord) throws IOException {
                    return mf.mask(sortedSetDocValues.lookupOrd(ord));
                }

                public long getValueCount() {
                    return sortedSetDocValues.getValueCount();
                }
            };
        }
        return sortedSetDocValues;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getNormValues(field) : null;
    }

    public PointValues getPointValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getPointValues(field) : null;
    }

    public Terms terms(String field) throws IOException {
        return this.isFls(field) ? this.wrapTerms(field, this.in.terms(field)) : null;
    }

    private Terms wrapTerms(String field, Terms terms) throws IOException {
        if (terms == null) {
            return null;
        }
        MaskedFieldsMap maskedFieldInfo = this.getRuntimeMaskedFieldInfo();
        if (maskedFieldInfo != null && maskedFieldInfo.anyMatch(this.handleKeyword(field))) {
            return null;
        }
        if ("_field_names".equals(field)) {
            return new FilteredTerms(terms);
        }
        return terms;
    }

    public Bits getLiveDocs() {
        return this.dge.getLiveDocs();
    }

    public int numDocs() {
        return this.dge.numDocs();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.dge.getReaderCacheHelper();
    }

    public boolean hasDeletions() {
        return this.dge.hasDeletions();
    }

    private MaskedFieldsMap getRuntimeMaskedFieldInfo() {
        Set mf;
        Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadContext, "_opendistro_security_masked_fields"));
        String maskedEval = SecurityUtils.evalMap(maskedFieldsMap, this.indexService.index().getName());
        if (maskedEval != null && (mf = (Set)maskedFieldsMap.get(maskedEval)) != null && !mf.isEmpty()) {
            return MaskedFieldsMap.extractMaskedFields(true, mf, this.salt, this.maskingAlgorithmDefault);
        }
        return null;
    }

    private String handleKeyword(String field) {
        if (field != null && field.endsWith(KEYWORD)) {
            return field.substring(0, field.length() - KEYWORD.length());
        }
        return field;
    }

    public StoredFields storedFields() throws IOException {
        this.ensureOpen();
        return new DlsFlsStoredFields(this.in.storedFields());
    }

    private String getRuntimeActionName() {
        return (String)this.threadContext.getTransient("_opendistro_security_action_name");
    }

    private boolean isSuggest() {
        return this.threadContext.getTransient("_opendistro_security_issuggest") == Boolean.TRUE;
    }

    private boolean applyDlsHere() {
        if (this.isSuggest()) {
            return true;
        }
        String action = this.getRuntimeActionName();
        assert (action != null);
        return !action.startsWith("indices:data/read/search");
    }

    private class DlsGetEvaluator {
        private final Bits liveBits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;
        private final boolean hasDeletions;

        public DlsGetEvaluator(DlsFlsFilterLeafReader dlsFlsFilterLeafReader, Query dlsQuery, LeafReader in, boolean applyDlsHere) throws IOException {
            if (dlsQuery != null && applyDlsHere) {
                IndexSearcher searcher = new IndexSearcher((IndexReader)dlsFlsFilterLeafReader);
                searcher.setQueryCache(null);
                Weight preserveWeight = searcher.rewrite(dlsQuery).createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                int maxDoc = in.maxDoc();
                FixedBitSet bits = new FixedBitSet(maxDoc);
                Scorer preserveScorer = preserveWeight.scorer(dlsFlsFilterLeafReader.getContext());
                if (preserveScorer != null) {
                    bits.or(preserveScorer.iterator());
                }
                if (in.hasDeletions()) {
                    Bits oldLiveDocs = in.getLiveDocs();
                    assert (oldLiveDocs != null);
                    BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
                    int i = it.nextDoc();
                    while (i != Integer.MAX_VALUE) {
                        if (!oldLiveDocs.get(i)) {
                            bits.clear(i);
                        }
                        i = it.nextDoc();
                    }
                }
                this.liveBits = bits;
                this.numDocs = in.numDocs();
                this.readerCacheHelper = null;
                this.hasDeletions = true;
            } else {
                this.liveBits = in.getLiveDocs();
                this.numDocs = in.numDocs();
                this.readerCacheHelper = in.getReaderCacheHelper();
                this.hasDeletions = in.hasDeletions();
            }
        }

        public Bits getLiveDocs() {
            return this.liveBits;
        }

        public int numDocs() {
            return this.numDocs;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }

        public boolean hasDeletions() {
            return this.hasDeletions;
        }
    }

    private class HashingCallback
    implements MapUtils.Callback {
        private HashingCallback() {
        }

        @Override
        public void call(String key, Map<String, Object> map, List<String> stack) {
            String field;
            MaskedField mf;
            Object v = map.get(key);
            if (v instanceof List && (mf = (MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.getMaskedField(field = stack.isEmpty() ? key : Joiner.on((char)'.').join(stack) + "." + key).orElse(null)) != null) {
                List listField = (List)v;
                ListIterator<Object> iterator = listField.listIterator();
                while (iterator.hasNext()) {
                    Object listFieldItem = iterator.next();
                    if (listFieldItem instanceof String) {
                        iterator.set(mf.mask((String)listFieldItem));
                        continue;
                    }
                    if (!(listFieldItem instanceof byte[])) continue;
                    iterator.set(mf.mask((byte[])listFieldItem));
                }
            }
            if (v != null && (v instanceof String || v instanceof byte[]) && (mf = (MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.getMaskedField(field = stack.isEmpty() ? key : Joiner.on((char)'.').join(stack) + "." + key).orElse(null)) != null) {
                if (v instanceof String) {
                    map.replace(key, mf.mask((String)v));
                } else {
                    map.replace(key, mf.mask((byte[])v));
                }
            }
        }
    }

    private static class MaskedFieldsMap {
        private final Map<WildcardMatcher, MaskedField> maskedFieldsMap;

        private MaskedFieldsMap(Map<WildcardMatcher, MaskedField> maskedFieldsMap) {
            this.maskedFieldsMap = maskedFieldsMap;
        }

        public static MaskedFieldsMap extractMaskedFields(boolean maskFields, Set<String> maskedFields, Salt salt, String algorithmDefault) {
            if (maskFields) {
                return new MaskedFieldsMap((Map)maskedFields.stream().map(mf -> new MaskedField((String)mf, salt, algorithmDefault)).collect(ImmutableMap.toImmutableMap(mf -> WildcardMatcher.from(mf.getName()), Function.identity())));
            }
            return new MaskedFieldsMap(Collections.emptyMap());
        }

        public Optional<MaskedField> getMaskedField(String fieldName) {
            return this.maskedFieldsMap.entrySet().stream().filter(entry -> ((WildcardMatcher)entry.getKey()).test(fieldName)).map(Map.Entry::getValue).findFirst();
        }

        public boolean anyMatch(String fieldName) {
            return this.maskedFieldsMap.keySet().stream().anyMatch((? super T m) -> m.test(fieldName));
        }

        public WildcardMatcher getMatcher() {
            return WildcardMatcher.from(this.maskedFieldsMap.keySet());
        }
    }

    private class DlsFlsStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader in;

        public DlsFlsStoredFieldsReader(StoredFieldsReader storedFieldsReader) {
            this.in = storedFieldsReader;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            visitor = DlsFlsFilterLeafReader.this.getDlsFlsVisitor(visitor);
            try {
                this.in.document(docID, visitor);
            }
            finally {
                DlsFlsFilterLeafReader.this.finishVisitor(visitor);
            }
        }

        public StoredFieldsReader clone() {
            return new DlsFlsStoredFieldsReader(this.in.clone());
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private class ComplianceAwareStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;
        private FieldReadCallback fieldReadCallback;

        public ComplianceAwareStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.fieldReadCallback = new FieldReadCallback(DlsFlsFilterLeafReader.this.threadContext, DlsFlsFilterLeafReader.this.indexService, DlsFlsFilterLeafReader.this.clusterService, DlsFlsFilterLeafReader.this.auditlog, DlsFlsFilterLeafReader.this.maskedFieldsMap.getMatcher(), DlsFlsFilterLeafReader.this.shardId);
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.fieldReadCallback.binaryFieldRead(fieldInfo, value);
            this.delegate.binaryField(fieldInfo, value);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.needsField(fieldInfo);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, Float.valueOf(value));
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.fieldReadCallback.numericFieldRead(fieldInfo, value);
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void finished() {
            this.fieldReadCallback.finished();
            this.fieldReadCallback = null;
        }
    }

    private class HashingStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;

        public HashingStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if (fieldInfo.name.equals("_source")) {
                BytesArray bytesRef = new BytesArray(value);
                Tuple bytesRefTuple = XContentHelper.convertToMap((BytesReference)bytesRef, (boolean)false, (MediaType)MediaTypeRegistry.JSON);
                Map filteredSource = (Map)bytesRefTuple.v2();
                MapUtils.deepTraverseMap(filteredSource, DlsFlsFilterLeafReader.this.HASH_CB);
                XContentBuilder xBuilder = XContentBuilder.builder((XContent)((MediaType)bytesRefTuple.v1()).xContent()).map(filteredSource);
                this.delegate.binaryField(fieldInfo, BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)xBuilder)));
            } else {
                this.delegate.binaryField(fieldInfo, value);
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.needsField(fieldInfo);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class FlsStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;

        public FlsStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if (fieldInfo.name.equals("_source")) {
                Map<String, Object> filteredSource = Utils.byteArrayToMutableJsonMap(value);
                if (!DlsFlsFilterLeafReader.this.canOptimize) {
                    filteredSource = DlsFlsFilterLeafReader.this.filterFunction.apply(filteredSource);
                } else if (!DlsFlsFilterLeafReader.this.excludesSet.isEmpty()) {
                    filteredSource.keySet().removeAll(DlsFlsFilterLeafReader.this.excludesSet);
                } else {
                    filteredSource.keySet().retainAll(DlsFlsFilterLeafReader.this.includesSet);
                }
                this.delegate.binaryField(fieldInfo, Utils.jsonMapToByteArray(filteredSource));
            } else {
                this.delegate.binaryField(fieldInfo, value);
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return DlsFlsFilterLeafReader.this.isFls(fieldInfo.name) ? this.delegate.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private final class FilteredTerms
    extends FilterLeafReader.FilterTerms {
        public FilteredTerms(Terms delegate) throws IOException {
            super(delegate);
        }

        public TermsEnum iterator() throws IOException {
            return new FilteredTermsEnum(this.in.iterator());
        }
    }

    private class DlsFlsStoredFields
    extends StoredFields {
        private final StoredFields in;

        public DlsFlsStoredFields(StoredFields storedFields) {
            this.in = storedFields;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            visitor = DlsFlsFilterLeafReader.this.getDlsFlsVisitor(visitor);
            try {
                this.in.document(docID, visitor);
            }
            finally {
                DlsFlsFilterLeafReader.this.finishVisitor(visitor);
            }
        }
    }

    private static class MaskedTermsEnum
    extends TermsEnum {
        private final TermsEnum delegate;
        private final MaskedField mf;

        public MaskedTermsEnum(TermsEnum delegate, MaskedField mf) {
            this.delegate = delegate;
            this.mf = mf;
        }

        public BytesRef next() throws IOException {
            return this.delegate.next();
        }

        public AttributeSource attributes() {
            return this.delegate.attributes();
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.delegate.seekExact(text);
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.delegate.seekCeil(text);
        }

        public void seekExact(long ord) throws IOException {
            this.delegate.seekExact(ord);
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            this.delegate.seekExact(term, state);
        }

        public BytesRef term() throws IOException {
            return this.mf.mask(this.delegate.term());
        }

        public long ord() throws IOException {
            return this.delegate.ord();
        }

        public IOBooleanSupplier prepareSeekExact(BytesRef bytesRef) throws IOException {
            return this.delegate.prepareSeekExact(bytesRef);
        }

        public int docFreq() throws IOException {
            return this.delegate.docFreq();
        }

        public long totalTermFreq() throws IOException {
            return this.delegate.totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.delegate.postings(reuse, flags);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            return this.delegate.impacts(flags);
        }

        public TermState termState() throws IOException {
            return this.delegate.termState();
        }
    }

    private final class FilteredTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        public FilteredTermsEnum(TermsEnum delegate) {
            super(delegate);
        }

        public BytesRef next() throws IOException {
            BytesRef nextBytesRef = this.in.next();
            while (nextBytesRef != null) {
                if (DlsFlsFilterLeafReader.this.isFls(nextBytesRef)) {
                    return nextBytesRef;
                }
                nextBytesRef = this.in.next();
            }
            return null;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            TermsEnum.SeekStatus delegateStatus = this.in.seekCeil(text);
            if (delegateStatus != TermsEnum.SeekStatus.END && DlsFlsFilterLeafReader.this.isFls(this.in.term())) {
                return delegateStatus;
            }
            if (delegateStatus == TermsEnum.SeekStatus.END) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }

        public boolean seekExact(BytesRef term) throws IOException {
            return DlsFlsFilterLeafReader.this.isFls(term) && this.in.seekExact(term);
        }

        public IOBooleanSupplier prepareSeekExact(BytesRef bytesRef) throws IOException {
            return () -> this.seekExact(bytesRef);
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class DlsFlsDirectoryReader
    extends FilterDirectoryReader {
        private final Set<String> includes;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final AuditLog auditlog;
        private final Set<String> maskedFields;
        private final ShardId shardId;
        private final Salt salt;

        public DlsFlsDirectoryReader(DirectoryReader in, Set<String> includes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, Set<String> maskedFields, ShardId shardId, Salt salt) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new DlsFlsSubReaderWrapper(includes, dlsQuery, indexService, threadContext, clusterService, auditlog, maskedFields, shardId, salt));
            this.includes = includes;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.auditlog = auditlog;
            this.maskedFields = maskedFields;
            this.shardId = shardId;
            this.salt = salt;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DlsFlsDirectoryReader(in, this.includes, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, this.maskedFields, this.shardId, this.salt);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class DlsFlsSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Set<String> includes;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final AuditLog auditlog;
        private final Set<String> maskedFields;
        private final ShardId shardId;
        private final Salt salt;

        public DlsFlsSubReaderWrapper(Set<String> includes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, AuditLog auditlog, Set<String> maskedFields, ShardId shardId, Salt salt) {
            this.includes = includes;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.auditlog = auditlog;
            this.maskedFields = maskedFields;
            this.shardId = shardId;
            this.salt = salt;
        }

        public LeafReader wrap(LeafReader reader) {
            return new DlsFlsFilterLeafReader(reader, this.includes, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, this.maskedFields, this.shardId, this.salt);
        }
    }
}

