/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.LuceniaSecurityPlugin;
import io.lucenia.security.configuration.DlsFilterLevelActionHandler;
import io.lucenia.security.configuration.DlsFlsRequestValve;
import io.lucenia.security.configuration.DlsQueryParser;
import io.lucenia.security.resolver.IndexResolverReplacer;
import io.lucenia.security.securityconf.EvaluatedDlsFlsConfig;
import io.lucenia.security.support.Base64Helper;
import io.lucenia.security.support.HeaderHelper;
import io.lucenia.security.support.SecurityUtils;
import io.skylite.SkyliteException;
import io.skylite.SkyliteSecurityException;
import io.skylite.SpecialPermission;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.RealtimeRequest;
import io.skylite.core.action.admin.cluster.shards.ClusterSearchShardsRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeRequest;
import io.skylite.core.action.bulk.BulkItemRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkShardRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.bucket.MultiBucketsAggregation;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.internal.SearchContext;

public class DlsFlsValveImpl
implements DlsFlsRequestValve {
    private static final String MAP_EXECUTION_HINT = "map";
    private static final Logger log = LogManager.getLogger(DlsFlsValveImpl.class);
    private final Client nodeClient;
    private final ClusterService clusterService;
    private final ThreadContext threadContext;
    private final Mode mode;
    private final DlsQueryParser dlsQueryParser;
    private final IndexNameExpressionResolver resolver;

    public DlsFlsValveImpl(Settings settings, Client nodeClient, ClusterService clusterService, IndexNameExpressionResolver resolver, NamedXContentRegistry namedXContentRegistry, ThreadContext threadContext) {
        this.nodeClient = nodeClient;
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.threadContext = threadContext;
        this.mode = Mode.get(settings);
        this.dlsQueryParser = new DlsQueryParser(namedXContentRegistry);
    }

    @Override
    public boolean invoke(String action, ActionRequest request, ActionListener<?> listener, EvaluatedDlsFlsConfig evaluatedDlsFlsConfig, IndexResolverReplacer.Resolved resolved) {
        SearchSourceBuilder source;
        boolean doFilterLevelDls;
        if (log.isDebugEnabled()) {
            log.debug("DlsFlsValveImpl.invoke()\nrequest: " + String.valueOf(request) + "\nevaluatedDlsFlsConfig: " + String.valueOf(evaluatedDlsFlsConfig) + "\nresolved: " + String.valueOf(resolved) + "\nmode: " + String.valueOf((Object)this.mode));
        }
        if (evaluatedDlsFlsConfig == null || evaluatedDlsFlsConfig.isEmpty()) {
            return true;
        }
        if (this.threadContext.getHeader("_opendistro_security_filter_level_dls_done") != null) {
            if (log.isDebugEnabled()) {
                log.debug("DLS is already done for: " + this.threadContext.getHeader("_opendistro_security_filter_level_dls_done"));
            }
            return true;
        }
        EvaluatedDlsFlsConfig filteredDlsFlsConfig = evaluatedDlsFlsConfig.filter(resolved);
        if (this.mode == Mode.FILTER_LEVEL) {
            doFilterLevelDls = true;
        } else if (this.mode == Mode.LUCENE_LEVEL) {
            doFilterLevelDls = false;
        } else {
            Mode modeByHeader = this.getDlsModeHeader();
            if (modeByHeader == Mode.FILTER_LEVEL) {
                doFilterLevelDls = true;
                log.debug("Doing filter-level DLS due to header");
            } else {
                doFilterLevelDls = this.dlsQueryParser.containsTermLookupQuery(filteredDlsFlsConfig.getAllQueries());
                if (doFilterLevelDls) {
                    this.setDlsModeHeader(Mode.FILTER_LEVEL);
                    log.debug("Doing filter-level DLS because the query contains a TLQ");
                } else {
                    log.debug("Doing lucene-level DLS because the query does not contain a TLQ");
                }
            }
        }
        if (!doFilterLevelDls) {
            this.setDlsHeaders(evaluatedDlsFlsConfig, request);
        }
        this.setFlsHeaders(evaluatedDlsFlsConfig, request);
        if (filteredDlsFlsConfig.isEmpty()) {
            return true;
        }
        if (request instanceof RealtimeRequest) {
            ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
        }
        if (request instanceof SearchRequest) {
            SearchRequest searchRequest = (SearchRequest)request;
            if (evaluatedDlsFlsConfig.hasFieldMasking() && searchRequest.source() != null && searchRequest.source().aggregations() != null) {
                for (AggregationBuilder aggregationBuilder : searchRequest.source().aggregations().getAggregatorFactories()) {
                    if (aggregationBuilder instanceof TermsAggregationBuilder) {
                        ((TermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                    }
                    if (aggregationBuilder instanceof SignificantTermsAggregationBuilder) {
                        ((SignificantTermsAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                    }
                    if (!(aggregationBuilder instanceof DiversifiedAggregationBuilder)) continue;
                    ((DiversifiedAggregationBuilder)aggregationBuilder).executionHint(MAP_EXECUTION_HINT);
                }
            }
            if (!evaluatedDlsFlsConfig.hasFls() && !evaluatedDlsFlsConfig.hasDls() && searchRequest.source().aggregations() != null) {
                boolean cacheable = true;
                for (AggregationBuilder af : searchRequest.source().aggregations().getAggregatorFactories()) {
                    if (!af.getType().equals("cardinality") && !af.getType().equals("count")) {
                        cacheable = false;
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (searchRequest.source() != null) {
                        sb.append(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)searchRequest.source()) + System.lineSeparator());
                    }
                    sb.append(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)af) + System.lineSeparator());
                    LogManager.getLogger((String)"debuglogger").error(sb.toString());
                }
                if (!cacheable) {
                    searchRequest.requestCache(Boolean.FALSE);
                } else {
                    LogManager.getLogger((String)"debuglogger").error("Shard requestcache enabled for " + (searchRequest.source() == null ? "<NULL>" : Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)searchRequest.source())));
                }
            } else {
                searchRequest.requestCache(Boolean.FALSE);
            }
        }
        if (request instanceof UpdateRequest) {
            listener.onFailure((Exception)new SkyliteSecurityException("Update is not supported when FLS or DLS or Fieldmasking is activated", new Object[0]));
            return false;
        }
        if (request instanceof BulkRequest) {
            for (DocWriteRequest inner : ((BulkRequest)request).requests()) {
                if (!(inner instanceof UpdateRequest)) continue;
                listener.onFailure((Exception)new SkyliteSecurityException("Update is not supported when FLS or DLS or Fieldmasking is activated", new Object[0]));
                return false;
            }
        }
        if (request instanceof BulkShardRequest) {
            for (BulkItemRequest inner : ((BulkShardRequest)request).items()) {
                if (!(inner.request() instanceof UpdateRequest)) continue;
                listener.onFailure((Exception)new SkyliteSecurityException("Update is not supported when FLS or DLS or Fieldmasking is activated", new Object[0]));
                return false;
            }
        }
        if (request instanceof ResizeRequest) {
            listener.onFailure((Exception)new SkyliteSecurityException("Resize is not supported when FLS or DLS or Fieldmasking is activated", new Object[0]));
            return false;
        }
        if (action.contains("plugins/replication")) {
            listener.onFailure((Exception)new SkyliteSecurityException("Cross Cluster Replication is not supported when FLS or DLS or Fieldmasking is activated", RestStatus.FORBIDDEN, new Object[0]));
            return false;
        }
        if (evaluatedDlsFlsConfig.hasDls() && request instanceof SearchRequest && (source = ((SearchRequest)request).source()) != null) {
            AggregatorFactories.Builder aggregations = source.aggregations();
            if (aggregations != null) {
                for (AggregationBuilder factory : aggregations.getAggregatorFactories()) {
                    if (!(factory instanceof TermsAggregationBuilder) || ((TermsAggregationBuilder)factory).minDocCount() != 0L) continue;
                    listener.onFailure((Exception)new SkyliteException("min_doc_count 0 is not supported when DLS is activated", new Object[0]));
                    return false;
                }
            }
            if (source.profile()) {
                listener.onFailure((Exception)new SkyliteSecurityException("Profiling is not supported when DLS is activated", new Object[0]));
                return false;
            }
        }
        if (doFilterLevelDls && filteredDlsFlsConfig.hasDls()) {
            return DlsFilterLevelActionHandler.handle(action, request, listener, evaluatedDlsFlsConfig, resolved, this.nodeClient, this.clusterService, LuceniaSecurityPlugin.GuiceHolder.getIndicesService(), this.resolver, this.dlsQueryParser, this.threadContext);
        }
        return true;
    }

    @Override
    public void handleSearchContext(SearchExecutionContext ctx, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry) {
        try {
            Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(threadPool.getThreadContext(), "_opendistro_security_dls_query"));
            SearchContext context = (SearchContext)ctx;
            String dlsEval = SecurityUtils.evalMap(queries, context.indexShard().indexSettings().getIndex().getName());
            if (dlsEval != null) {
                if (context.suggest() != null) {
                    return;
                }
                assert (context.parsedQuery() != null);
                Set unparsedDlsQueries = (Set)queries.get(dlsEval);
                if (unparsedDlsQueries != null && !unparsedDlsQueries.isEmpty()) {
                    BooleanQuery.Builder queryBuilder = this.dlsQueryParser.parse(unparsedDlsQueries, context.getQueryShardContext(), q -> new ConstantScoreQuery(q));
                    queryBuilder.add(context.parsedQuery().query(), BooleanClause.Occur.MUST);
                    ParsedQuery dlsQuery = new ParsedQuery((Query)queryBuilder.build());
                    if (dlsQuery != null) {
                        context.parsedQuery(dlsQuery);
                        context.preProcess(true);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating dls for a search query: " + String.valueOf(e), e);
        }
    }

    @Override
    public void onQueryPhase(QuerySearchResult queryResult) {
        InternalAggregations aggregations = (InternalAggregations)queryResult.aggregations().expand();
        assert (aggregations != null);
        queryResult.aggregations(InternalAggregations.from((List)((List)StreamSupport.stream(aggregations.spliterator(), false).map(aggregation -> DlsFlsValveImpl.aggregateBuckets((InternalAggregation)aggregation)).collect(ImmutableList.toImmutableList()))));
    }

    private static InternalAggregation aggregateBuckets(InternalAggregation aggregation) {
        StringTerms stringTerms;
        List<StringTerms.Bucket> buckets;
        if (aggregation instanceof StringTerms && (buckets = (stringTerms = (StringTerms)aggregation).getBuckets()).size() > 1) {
            buckets = DlsFlsValveImpl.mergeBuckets(buckets, StringTermsGetter.getReduceOrder(stringTerms).comparator());
            aggregation = stringTerms.create(buckets);
        }
        return aggregation;
    }

    private static List<StringTerms.Bucket> mergeBuckets(List<StringTerms.Bucket> buckets, Comparator<MultiBucketsAggregation.Bucket> comparator) {
        if (log.isDebugEnabled()) {
            log.debug("Merging buckets: {}", buckets.stream().map(b -> b.getKeyAsString()).collect(ImmutableList.toImmutableList()));
        }
        buckets.sort(comparator);
        BucketMerger merger = new BucketMerger(comparator, buckets.size());
        buckets.stream().forEach(merger);
        buckets = merger.getBuckets();
        if (log.isDebugEnabled()) {
            log.debug("New buckets: {}", buckets.stream().map(b -> b.getKeyAsString()).collect(ImmutableList.toImmutableList()));
        }
        return buckets;
    }

    private void setDlsHeaders(EvaluatedDlsFlsConfig dlsFls, ActionRequest request) {
        if (!dlsFls.getDlsQueriesByIndex().isEmpty()) {
            Map<String, Set<String>> dlsQueries = dlsFls.getDlsQueriesByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(this.threadContext)) {
                this.threadContext.addResponseHeader("_opendistro_security_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for DLS info: {}", dlsQueries);
                }
            } else if (this.threadContext.getHeader("_opendistro_security_dls_query") != null) {
                Serializable deserializedDlsQueries = Base64Helper.deserializeObject(this.threadContext.getHeader("_opendistro_security_dls_query"), (Boolean)this.threadContext.getTransient("plugins.security.use_jdk_serialization"));
                if (!dlsQueries.equals(deserializedDlsQueries)) {
                    throw new SkyliteSecurityException("_opendistro_security_dls_query does not match (SG 900D)", new Object[0]);
                }
            } else {
                this.threadContext.putHeader("_opendistro_security_dls_query", Base64Helper.serializeObject((Serializable)((Object)dlsQueries)));
                if (log.isDebugEnabled()) {
                    log.debug("attach DLS info: {}", dlsQueries);
                }
            }
        }
    }

    private void setDlsModeHeader(Mode mode) {
        String modeString = mode.name();
        if (this.threadContext.getHeader("_opendistro_security_dls_mode") != null) {
            if (!modeString.equals(this.threadContext.getHeader("_opendistro_security_dls_mode"))) {
                log.warn("Cannot update DLS mode to " + String.valueOf((Object)mode) + "; current: " + this.threadContext.getHeader("_opendistro_security_dls_mode"));
            }
        } else {
            this.threadContext.putHeader("_opendistro_security_dls_mode", modeString);
        }
    }

    private Mode getDlsModeHeader() {
        String modeString = this.threadContext.getHeader("_opendistro_security_dls_mode");
        if (modeString != null) {
            return Mode.valueOf(modeString);
        }
        return null;
    }

    private void setFlsHeaders(EvaluatedDlsFlsConfig dlsFls, ActionRequest request) {
        if (!dlsFls.getFieldMaskingByIndex().isEmpty()) {
            Map<String, Set<String>> maskedFieldsMap = dlsFls.getFieldMaskingByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(this.threadContext)) {
                this.threadContext.addResponseHeader("_opendistro_security_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for masked fields info: {}", maskedFieldsMap);
                }
            } else if (this.threadContext.getHeader("_opendistro_security_masked_fields") != null) {
                if (!maskedFieldsMap.equals(Base64Helper.deserializeObject(this.threadContext.getHeader("_opendistro_security_masked_fields"), (Boolean)this.threadContext.getTransient("plugins.security.use_jdk_serialization")))) {
                    throw new SkyliteSecurityException("_opendistro_security_masked_fields does not match (SG 901D)", new Object[0]);
                }
                if (log.isDebugEnabled()) {
                    log.debug("_opendistro_security_masked_fields already set");
                }
            } else {
                this.threadContext.putHeader("_opendistro_security_masked_fields", Base64Helper.serializeObject((Serializable)((Object)maskedFieldsMap)));
                if (log.isDebugEnabled()) {
                    log.debug("attach masked fields info: {}", maskedFieldsMap);
                }
            }
        }
        if (!dlsFls.getFlsByIndex().isEmpty()) {
            Map<String, Set<String>> flsFields = dlsFls.getFlsByIndex();
            if (request instanceof ClusterSearchShardsRequest && HeaderHelper.isTrustedClusterRequest(this.threadContext)) {
                this.threadContext.addResponseHeader("_opendistro_security_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (log.isDebugEnabled()) {
                    log.debug("added response header for FLS info: {}", flsFields);
                }
            } else if (this.threadContext.getHeader("_opendistro_security_fls_fields") != null) {
                if (!flsFields.equals(Base64Helper.deserializeObject(this.threadContext.getHeader("_opendistro_security_fls_fields"), (Boolean)this.threadContext.getTransient("plugins.security.use_jdk_serialization")))) {
                    throw new SkyliteSecurityException("_opendistro_security_fls_fields does not match (SG 901D) " + String.valueOf(flsFields) + "---" + String.valueOf(Base64Helper.deserializeObject(this.threadContext.getHeader("_opendistro_security_fls_fields"), (Boolean)this.threadContext.getTransient("plugins.security.use_jdk_serialization"))), new Object[0]);
                }
                if (log.isDebugEnabled()) {
                    log.debug("_opendistro_security_fls_fields already set");
                }
            } else {
                this.threadContext.putHeader("_opendistro_security_fls_fields", Base64Helper.serializeObject((Serializable)((Object)flsFields)));
                if (log.isDebugEnabled()) {
                    log.debug("attach FLS info: {}", flsFields);
                }
            }
        }
    }

    public static enum Mode {
        ADAPTIVE,
        LUCENE_LEVEL,
        FILTER_LEVEL;


        static Mode get(Settings settings) {
            String modeString = settings.get("plugins.security.dls.mode");
            if ("adaptive".equalsIgnoreCase(modeString)) {
                return ADAPTIVE;
            }
            if ("lucene_level".equalsIgnoreCase(modeString)) {
                return LUCENE_LEVEL;
            }
            if ("filter_level".equalsIgnoreCase(modeString)) {
                return FILTER_LEVEL;
            }
            return ADAPTIVE;
        }
    }

    private static class StringTermsGetter {
        private static final Field REDUCE_ORDER = StringTermsGetter.getField(InternalTerms.class, "reduceOrder");
        private static final Field TERM_BYTES = StringTermsGetter.getField(StringTerms.Bucket.class, "termBytes");
        private static final Field FORMAT = StringTermsGetter.getField(InternalTerms.Bucket.class, "format");

        private StringTermsGetter() {
        }

        private static <T> Field getFieldPrivileged(Class<T> cls, String name) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException | SecurityException e) {
                log.error("Failed to get class {} declared field {}", (Object)cls.getSimpleName(), (Object)name, (Object)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private static <T> Field getField(Class<T> cls, String name) {
            SpecialPermission.check();
            return AccessController.doPrivileged(() -> StringTermsGetter.getFieldPrivileged(cls, name));
        }

        private static <T, C> T getFieldValue(Field field, C c) {
            try {
                return (T)field.get(c);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Exception while getting value {} of class {}", (Object)field.getName(), (Object)c.getClass().getSimpleName(), (Object)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        public static BucketOrder getReduceOrder(StringTerms stringTerms) {
            return (BucketOrder)StringTermsGetter.getFieldValue(REDUCE_ORDER, stringTerms);
        }

        public static BytesRef getTerm(StringTerms.Bucket bucket) {
            return (BytesRef)StringTermsGetter.getFieldValue(TERM_BYTES, bucket);
        }

        public static DocValueFormat getDocValueFormat(StringTerms.Bucket bucket) {
            return (DocValueFormat)StringTermsGetter.getFieldValue(FORMAT, bucket);
        }
    }

    private static class BucketMerger
    implements Consumer<StringTerms.Bucket> {
        private Comparator<MultiBucketsAggregation.Bucket> comparator;
        private StringTerms.Bucket bucket = null;
        private int mergeCount;
        private long mergedDocCount;
        private long mergedDocCountError;
        private boolean showDocCountError = true;
        private final ImmutableList.Builder<StringTerms.Bucket> builder;

        BucketMerger(Comparator<MultiBucketsAggregation.Bucket> comparator, int size) {
            this.comparator = Objects.requireNonNull(comparator);
            this.builder = ImmutableList.builderWithExpectedSize((int)size);
        }

        private void finalizeBucket() {
            if (this.mergeCount == 1) {
                this.builder.add((Object)this.bucket);
            } else {
                this.builder.add((Object)new StringTerms.Bucket(StringTermsGetter.getTerm(this.bucket), this.mergedDocCount, (InternalAggregations)this.bucket.getAggregations(), this.showDocCountError, this.mergedDocCountError, StringTermsGetter.getDocValueFormat(this.bucket)));
            }
        }

        private void merge(StringTerms.Bucket bucket) {
            if (this.bucket != null && (bucket == null || this.comparator.compare((MultiBucketsAggregation.Bucket)this.bucket, (MultiBucketsAggregation.Bucket)bucket) != 0)) {
                this.finalizeBucket();
                this.bucket = null;
                this.mergeCount = 0;
                this.mergedDocCount = 0L;
                this.mergedDocCountError = 0L;
                this.showDocCountError = true;
            }
        }

        public List<StringTerms.Bucket> getBuckets() {
            this.merge(null);
            return this.builder.build();
        }

        @Override
        public void accept(StringTerms.Bucket bucket) {
            this.merge(bucket);
            ++this.mergeCount;
            this.mergedDocCount += bucket.getDocCount();
            if (this.showDocCountError) {
                try {
                    this.mergedDocCountError += bucket.getDocCountError();
                }
                catch (IllegalStateException e) {
                    this.showDocCountError = false;
                }
            }
            this.bucket = bucket;
        }
    }
}

