/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.lucenia.security.queries.QueryBuilderTraverser;
import io.skylite.common.xcontent.json.JsonXContent;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.opensearch.index.query.TermsQueryBuilder;

public final class DlsQueryParser {
    private static final Logger log = LogManager.getLogger(DlsQueryParser.class);
    private static final Query NON_NESTED_QUERY = new BooleanQuery.Builder().add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add((Query)new PrefixQuery(new Term("_type", "__")), BooleanClause.Occur.MUST_NOT).build();
    private static Cache<String, QueryBuilder> parsedQueryCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(4L, TimeUnit.HOURS).build();
    private static Cache<String, Boolean> queryContainsTlqCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(4L, TimeUnit.HOURS).build();
    private final NamedXContentRegistry namedXContentRegistry;

    public DlsQueryParser(NamedXContentRegistry namedXContentRegistry) {
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public BooleanQuery.Builder parse(Set<String> unparsedDlsQueries, QueryShardContext queryShardContext) {
        return this.parse(unparsedDlsQueries, queryShardContext, null);
    }

    public BooleanQuery.Builder parse(Set<String> unparsedDlsQueries, QueryShardContext queryShardContext, Function<Query, Query> queryMapFunction) {
        if (unparsedDlsQueries == null || unparsedDlsQueries.isEmpty()) {
            return null;
        }
        boolean hasNestedMapping = queryShardContext.hasNested();
        BooleanQuery.Builder dlsQueryBuilder = new BooleanQuery.Builder();
        dlsQueryBuilder.setMinimumNumberShouldMatch(1);
        for (String unparsedDlsQuery : unparsedDlsQueries) {
            ParsedQuery parsedQuery = queryShardContext.toQuery(this.parse(unparsedDlsQuery));
            Query dlsQuery = parsedQuery.query();
            if (queryMapFunction != null) {
                dlsQuery = queryMapFunction.apply(dlsQuery);
            }
            dlsQueryBuilder.add(dlsQuery, BooleanClause.Occur.SHOULD);
            if (!hasNestedMapping) continue;
            DlsQueryParser.handleNested(queryShardContext, dlsQueryBuilder, dlsQuery);
        }
        return dlsQueryBuilder;
    }

    private static void handleNested(QueryShardContext queryShardContext, BooleanQuery.Builder dlsQueryBuilder, Query parentQuery) {
        BitSetProducer parentDocumentsFilter = queryShardContext.bitsetFilter(NON_NESTED_QUERY);
        dlsQueryBuilder.add((Query)new ToChildBlockJoinQuery(parentQuery, parentDocumentsFilter), BooleanClause.Occur.SHOULD);
    }

    public QueryBuilder parse(final String unparsedDlsQuery) {
        try {
            QueryBuilder qb = (QueryBuilder)parsedQueryCache.get((Object)unparsedDlsQuery, (Callable)new Callable<QueryBuilder>(){

                @Override
                public QueryBuilder call() throws Exception {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(DlsQueryParser.this.namedXContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, unparsedDlsQuery);
                    return QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                }
            });
            return qb;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while parsing " + unparsedDlsQuery, e.getCause());
        }
    }

    boolean containsTermLookupQuery(Set<String> unparsedQueries) {
        for (String query : unparsedQueries) {
            if (!this.containsTermLookupQuery(query)) continue;
            if (log.isDebugEnabled()) {
                log.debug("containsTermLookupQuery() returns true due to " + query + "\nqueries: " + String.valueOf(unparsedQueries));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("containsTermLookupQuery() returns false\nqueries: " + String.valueOf(unparsedQueries));
        }
        return false;
    }

    boolean containsTermLookupQuery(String query) {
        try {
            return (Boolean)queryContainsTlqCache.get((Object)query, () -> {
                QueryBuilder queryBuilder = this.parse(query);
                return QueryBuilderTraverser.exists(queryBuilder, q -> q instanceof TermsQueryBuilder && ((TermsQueryBuilder)q).termsLookup() != null);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error handling parsing " + query, e.getCause());
        }
    }
}

