/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.configuration;

import com.google.common.base.Splitter;
import com.rfksystems.blake2b.Blake2b;
import io.lucenia.security.configuration.Salt;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.BytesRef;
import org.bouncycastle.util.encoders.Hex;

public class MaskedField {
    private final String name;
    private String algo = null;
    private List<RegexReplacement> regexReplacements;
    private final byte[] defaultSalt;
    private final String defaultAlgorithm;

    public MaskedField(String value, Salt salt, String defaultAlgorithm) {
        this.defaultSalt = salt.getSalt16();
        this.defaultAlgorithm = defaultAlgorithm;
        List tokens = Splitter.on((String)"::").splitToList((CharSequence)Objects.requireNonNull(value));
        int tokenCount = tokens.size();
        if (tokenCount == 1) {
            this.name = (String)tokens.get(0);
        } else if (tokenCount == 2) {
            this.name = (String)tokens.get(0);
            this.algo = (String)tokens.get(1);
        } else if (tokenCount >= 3 && tokenCount % 2 == 1) {
            this.name = (String)tokens.get(0);
            this.regexReplacements = new ArrayList<RegexReplacement>((tokenCount - 1) / 2);
            for (int i = 1; i < tokenCount - 1; i += 2) {
                this.regexReplacements.add(new RegexReplacement((String)tokens.get(i), (String)tokens.get(i + 1)));
            }
        } else {
            throw new IllegalArgumentException("Expected 1 or 2 or >=3 (but then odd count) tokens, got " + tokenCount);
        }
    }

    public final void isValid() throws Exception {
        this.mask(new byte[]{1, 2, 3, 4, 5});
    }

    public byte[] mask(byte[] value) {
        if (this.algo != null) {
            return MaskedField.customHash(value, this.algo);
        }
        if (this.regexReplacements != null) {
            String cur = new String(value, StandardCharsets.UTF_8);
            for (RegexReplacement rr : this.regexReplacements) {
                cur = cur.replaceAll(rr.getRegex(), rr.getReplacement());
            }
            return cur.getBytes(StandardCharsets.UTF_8);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.defaultAlgorithm)) {
            return MaskedField.customHash(value, this.defaultAlgorithm);
        }
        return this.blake2bHash(value);
    }

    public String mask(String value) {
        return new String(this.mask(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public BytesRef mask(BytesRef value) {
        if (value == null) {
            return null;
        }
        BytesRef copy = BytesRef.deepCopyOf((BytesRef)value);
        return new BytesRef(this.mask(copy.bytes));
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algo == null ? 0 : this.algo.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.regexReplacements == null ? 0 : this.regexReplacements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaskedField other = (MaskedField)obj;
        if (this.algo == null ? other.algo != null : !this.algo.equals(other.algo)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.regexReplacements == null ? other.regexReplacements != null : !this.regexReplacements.equals(other.regexReplacements));
    }

    public String toString() {
        return "MaskedField [name=" + this.name + ", algo=" + this.algo + ", regexReplacements=" + String.valueOf(this.regexReplacements) + ", defaultSalt=" + Arrays.toString(this.defaultSalt) + ", defaultAlgorithm=" + this.defaultAlgorithm + ", isDefault()=" + this.isDefault() + "]";
    }

    private boolean isDefault() {
        return this.regexReplacements == null && this.algo == null;
    }

    private static byte[] customHash(byte[] in, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return Hex.encode((byte[])digest.digest(in));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private byte[] blake2bHash(byte[] in) {
        Blake2b hash = new Blake2b(null, 32, null, this.defaultSalt);
        hash.update(in, 0, in.length);
        byte[] out = new byte[hash.getDigestSize()];
        hash.digest(out, 0);
        return Hex.encode((byte[])out);
    }

    private static class RegexReplacement {
        private final String regex;
        private final String replacement;

        public RegexReplacement(String regex, String replacement) {
            this.regex = regex.substring(1).substring(0, regex.length() - 2);
            this.replacement = replacement;
        }

        public String getRegex() {
            return this.regex;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexReplacement other = (RegexReplacement)obj;
            if (this.regex == null ? other.regex != null : !this.regex.equals(other.regex)) {
                return false;
            }
            return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
        }

        public String toString() {
            return "RegexReplacement [regex=" + this.regex + ", replacement=" + this.replacement + "]";
        }
    }
}

