/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.api.SecurityConfiguration;
import io.lucenia.security.dlic.rest.validation.EndpointValidator;
import io.lucenia.security.dlic.rest.validation.RequestContentValidator;
import io.lucenia.security.dlic.rest.validation.ValidationResult;
import io.lucenia.security.securityconf.impl.CType;
import io.skylite.common.CheckedFunction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class AllowlistApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security/api/allowlist"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_security/api/allowlist"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/_plugins/_security/api/allowlist"));

    @Inject
    public AllowlistApiAction(Endpoint endpoint, ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(endpoint, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::allowListApiRequestHandlers);
    }

    private void allowListApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.verifyAccessForAllMethods().onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.loadConfigurationWithRequestContent("config", (RestRequest)request).map(this::addEntityToConfig))).override(RestRequest.Method.DELETE, RequestHandler.methodNotImplementedHandler);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return CType.ALLOWLIST;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return AllowlistApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return AllowlistApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return AllowlistApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"enabled", (Object)((Object)RequestContentValidator.DataType.BOOLEAN), (Object)"requests", (Object)((Object)RequestContentValidator.DataType.OBJECT));
                    }
                });
            }
        };
    }
}

