/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import io.lucenia.security.action.configupdate.ConfigUpdateAction;
import io.lucenia.security.action.configupdate.ConfigUpdateRequest;
import io.lucenia.security.action.configupdate.ConfigUpdateResponse;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.Responses;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.securityconf.impl.CType;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.threadpool.ThreadPool;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlushCacheApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(FlushCacheApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/cache"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/cache")));

    @Inject
    public FlushCacheApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.CACHE, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::flushCacheApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    private void flushCacheApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.DELETE, (channel, request, client) -> client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0])), (ActionListener)new ActionListener<ConfigUpdateResponse>(this){

            public void onResponse(ConfigUpdateResponse configUpdateResponse) {
                if (configUpdateResponse.hasFailures()) {
                    LOGGER.error("Cannot flush cache due to", (Throwable)configUpdateResponse.failures().get(0));
                    Responses.internalSeverError(channel, "Cannot flush cache due to " + ((FailedNodeException)configUpdateResponse.failures().get(0)).getMessage() + ".");
                    return;
                }
                LOGGER.debug("cache flushed successfully");
                Responses.ok(channel, "Cache flushed successfully.");
            }

            public void onFailure(Exception e) {
                LOGGER.error("Cannot flush cache due to", (Throwable)e);
                Responses.internalSeverError(channel, "Cannot flush cache due to " + e.getMessage() + ".");
            }
        }));
    }

    @Override
    protected CType getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }
}

