/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.lucenia.security.dlic.rest.api.AbstractApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.RequestHandler;
import io.lucenia.security.dlic.rest.api.Responses;
import io.lucenia.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.api.SecurityConfiguration;
import io.lucenia.security.dlic.rest.support.Utils;
import io.lucenia.security.dlic.rest.validation.EndpointValidator;
import io.lucenia.security.dlic.rest.validation.RequestContentValidator;
import io.lucenia.security.securityconf.impl.CType;
import io.lucenia.security.securityconf.impl.DashboardSignInOption;
import io.lucenia.security.securityconf.impl.SecurityDynamicConfiguration;
import io.lucenia.security.securityconf.impl.v7.ConfigV7;
import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.CheckedConsumer;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MultiTenancyConfigApiAction
extends AbstractApiAction {
    public static final String DEFAULT_TENANT_JSON_PROPERTY = "default_tenant";
    public static final String PRIVATE_TENANT_ENABLED_JSON_PROPERTY = "private_tenant_enabled";
    public static final String MULTITENANCY_ENABLED_JSON_PROPERTY = "multitenancy_enabled";
    public static final String SIGN_IN_OPTIONS = "sign_in_options";
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/tenancy/config"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/tenancy/config")));
    private static final Set<String> ACCEPTABLE_DEFAULT_TENANTS = Set.of("", "global", "private");

    @Override
    public String getName() {
        return "Multi Tenancy actions to Retrieve / Update configs.";
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    public MultiTenancyConfigApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.TENANTS, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::multiTenancyConfigApiRequestHandlers);
    }

    @Override
    protected CType getConfigType() {
        return CType.CONFIG;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return MultiTenancyConfigApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return MultiTenancyConfigApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return MultiTenancyConfigApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)MultiTenancyConfigApiAction.DEFAULT_TENANT_JSON_PROPERTY, (Object)((Object)RequestContentValidator.DataType.STRING), (Object)MultiTenancyConfigApiAction.PRIVATE_TENANT_ENABLED_JSON_PROPERTY, (Object)((Object)RequestContentValidator.DataType.BOOLEAN), (Object)MultiTenancyConfigApiAction.MULTITENANCY_ENABLED_JSON_PROPERTY, (Object)((Object)RequestContentValidator.DataType.BOOLEAN), (Object)MultiTenancyConfigApiAction.SIGN_IN_OPTIONS, (Object)((Object)RequestContentValidator.DataType.ARRAY));
                    }
                });
            }
        };
    }

    private ToXContent multitenancyContent(ConfigV7 config) {
        return (builder, params) -> builder.startObject().field(DEFAULT_TENANT_JSON_PROPERTY, config.dynamic.kibana.default_tenant).field(PRIVATE_TENANT_ENABLED_JSON_PROPERTY, config.dynamic.kibana.private_tenant_enabled).field(MULTITENANCY_ENABLED_JSON_PROPERTY, config.dynamic.kibana.multitenancy_enabled).field(SIGN_IN_OPTIONS, config.dynamic.kibana.sign_in_options).endObject();
    }

    private void multiTenancyConfigApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.GET, (channel, request, client) -> this.loadConfiguration(this.getConfigType(), false, false).valid(configuration -> {
            ConfigV7 config = (ConfigV7)configuration.getCEntry(CType.CONFIG.toLCString());
            Responses.ok(channel, this.multitenancyContent(config));
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).override(RestRequest.Method.PUT, (channel, request, client) -> this.loadConfigurationWithRequestContent("config", request).valid((CheckedConsumer<SecurityConfiguration, IOException>)((CheckedConsumer)securityConfiguration -> this.updateMultitenancy(channel, client, (SecurityConfiguration)securityConfiguration))).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
    }

    protected void updateMultitenancy(final RestChannel channel, Client client, SecurityConfiguration securityConfiguration) throws IOException {
        SecurityDynamicConfiguration<?> dynamicConfiguration = securityConfiguration.configuration();
        final ConfigV7 config = (ConfigV7)dynamicConfiguration.getCEntry(CType.CONFIG.toLCString());
        this.updateAndValidatesValues(config, securityConfiguration.requestContent());
        dynamicConfiguration.putCEntry(CType.CONFIG.toLCString(), config);
        this.saveOrUpdateConfiguration(client, dynamicConfiguration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(channel){

            public void onResponse(IndexResponse indexResponse) {
                Responses.ok(channel, MultiTenancyConfigApiAction.this.multitenancyContent(config));
            }
        });
    }

    private void updateAndValidatesValues(ConfigV7 config, JsonNode jsonContent) {
        if (Objects.nonNull(jsonContent.findValue(DEFAULT_TENANT_JSON_PROPERTY))) {
            config.dynamic.kibana.default_tenant = jsonContent.findValue(DEFAULT_TENANT_JSON_PROPERTY).asText();
        }
        if (Objects.nonNull(jsonContent.findValue(PRIVATE_TENANT_ENABLED_JSON_PROPERTY))) {
            config.dynamic.kibana.private_tenant_enabled = jsonContent.findValue(PRIVATE_TENANT_ENABLED_JSON_PROPERTY).booleanValue();
        }
        if (Objects.nonNull(jsonContent.findValue(MULTITENANCY_ENABLED_JSON_PROPERTY))) {
            config.dynamic.kibana.multitenancy_enabled = jsonContent.findValue(MULTITENANCY_ENABLED_JSON_PROPERTY).asBoolean();
        }
        if (jsonContent.hasNonNull(SIGN_IN_OPTIONS) && !jsonContent.findValue(SIGN_IN_OPTIONS).isEmpty()) {
            JsonNode newOptions = jsonContent.findValue(SIGN_IN_OPTIONS);
            List<DashboardSignInOption> options = this.getNewSignInOptions(newOptions, config.dynamic.authc);
            config.dynamic.kibana.sign_in_options = options;
        }
        String defaultTenant = Optional.ofNullable(config.dynamic.kibana.default_tenant).map(String::toLowerCase).orElse("");
        if (!config.dynamic.kibana.private_tenant_enabled && "private".equals(defaultTenant)) {
            throw new IllegalArgumentException("Private tenant can not be disabled if it is the default tenant.");
        }
        if (ACCEPTABLE_DEFAULT_TENANTS.contains(defaultTenant)) {
            return;
        }
        Set availableTenants = this.securityApiDependencies.configurationRepository().getConfiguration(CType.TENANTS).getCEntries().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (!availableTenants.contains(defaultTenant)) {
            throw new IllegalArgumentException(config.dynamic.kibana.default_tenant + " can not be set to default tenant. Default tenant should be selected from one of the available tenants.");
        }
    }

    private List<DashboardSignInOption> getNewSignInOptions(JsonNode newOptions, ConfigV7.Authc authc) {
        Set<String> domains = authc.getDomains().keySet();
        return IntStream.range(0, newOptions.size()).mapToObj(arg_0 -> ((JsonNode)newOptions).get(arg_0)).map(JsonNode::asText).filter(option -> {
            if (option.equals(DashboardSignInOption.ANONYMOUS.toString()) || domains.stream().anyMatch(domain -> domain.contains(option.toLowerCase()))) {
                return true;
            }
            throw new IllegalArgumentException("Validation failure: " + option.toUpperCase() + " authentication provider is not available for this cluster.");
        }).map(DashboardSignInOption::valueOf).collect(Collectors.toList());
    }
}

