/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import org.opensearch.rest.BytesRestResponse;

public class Responses {
    public static void ok(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.OK, message);
    }

    public static void ok(RestChannel channel, ToXContent toXContent) {
        Responses.response(channel, RestStatus.OK, toXContent);
    }

    public static void created(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.CREATED, message);
    }

    public static void methodNotImplemented(RestChannel channel, RestRequest.Method method) {
        Responses.notImplemented(channel, "Method " + method.name() + " not supported for this action.");
    }

    public static void notImplemented(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.NOT_IMPLEMENTED, message);
    }

    public static void notFound(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.NOT_FOUND, message);
    }

    public static void conflict(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.CONFLICT, message);
    }

    public static void internalSeverError(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static void forbidden(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.FORBIDDEN, message);
    }

    public static void badRequest(RestChannel channel, String message) {
        Responses.response(channel, RestStatus.BAD_REQUEST, message);
    }

    public static void unauthorized(RestChannel channel) {
        Responses.response(channel, RestStatus.UNAUTHORIZED, "Unauthorized");
    }

    public static void response(RestChannel channel, RestStatus status, String message) {
        Responses.response(channel, status, Responses.payload(status, message));
    }

    public static void response(RestChannel channel, RestStatus status, ToXContent toXContent) {
        try (XContentBuilder builder = channel.newBuilder();){
            toXContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (IOException ioe) {
            throw SkyliteExceptionsHelper.convertToOpenSearchException((Exception)ioe);
        }
    }

    public static ToXContent forbiddenMessage(String message) {
        return Responses.payload(RestStatus.FORBIDDEN, message);
    }

    public static ToXContent badRequestMessage(String message) {
        return Responses.payload(RestStatus.BAD_REQUEST, message);
    }

    public static ToXContent methodNotImplementedMessage(RestRequest.Method method) {
        return Responses.payload(RestStatus.NOT_FOUND, "Method " + method.name() + " not supported for this action.");
    }

    public static ToXContent notFoundMessage(String message) {
        return Responses.payload(RestStatus.NOT_FOUND, message);
    }

    public static ToXContent conflictMessage(String message) {
        return Responses.payload(RestStatus.CONFLICT, message);
    }

    public static ToXContent payload(RestStatus status, String message) {
        return (builder, params) -> builder.startObject().field("status", status.name()).field("message", message).endObject();
    }
}

