/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.security.dlic.rest.api;

import io.lucenia.security.auditlog.AuditLog;
import io.lucenia.security.configuration.AdminDNs;
import io.lucenia.security.configuration.ConfigurationRepository;
import io.lucenia.security.dlic.rest.api.AccountApiAction;
import io.lucenia.security.dlic.rest.api.ActionGroupsApiAction;
import io.lucenia.security.dlic.rest.api.AllowlistApiAction;
import io.lucenia.security.dlic.rest.api.AuditApiAction;
import io.lucenia.security.dlic.rest.api.AuthTokenProcessorAction;
import io.lucenia.security.dlic.rest.api.ConfigUpgradeApiAction;
import io.lucenia.security.dlic.rest.api.Endpoint;
import io.lucenia.security.dlic.rest.api.FlushCacheApiAction;
import io.lucenia.security.dlic.rest.api.InternalUsersApiAction;
import io.lucenia.security.dlic.rest.api.MigrateApiAction;
import io.lucenia.security.dlic.rest.api.MultiTenancyConfigApiAction;
import io.lucenia.security.dlic.rest.api.NodesDnApiAction;
import io.lucenia.security.dlic.rest.api.PermissionsInfoAction;
import io.lucenia.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.RestApiPrivilegesEvaluator;
import io.lucenia.security.dlic.rest.api.RolesApiAction;
import io.lucenia.security.dlic.rest.api.RolesMappingApiAction;
import io.lucenia.security.dlic.rest.api.SecurityApiDependencies;
import io.lucenia.security.dlic.rest.api.SecurityConfigApiAction;
import io.lucenia.security.dlic.rest.api.SecuritySSLCertsApiAction;
import io.lucenia.security.dlic.rest.api.TenantsApiAction;
import io.lucenia.security.dlic.rest.api.ValidateApiAction;
import io.lucenia.security.dlic.rest.api.WhitelistApiAction;
import io.lucenia.security.privileges.PrivilegesEvaluator;
import io.lucenia.security.ssl.SecurityKeyStore;
import io.lucenia.security.ssl.transport.PrincipalExtractor;
import io.lucenia.security.user.UserService;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.opensearch.rest.RestController;

public class SecurityRestApiActions {
    public static Collection<RestHandler> getHandler(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDns, ConfigurationRepository configurationRepository, ClusterService clusterService, PrincipalExtractor principalExtractor, PrivilegesEvaluator evaluator, ThreadPool threadPool, AuditLog auditLog, SecurityKeyStore securityKeyStore, UserService userService, boolean certificatesReloadEnabled) {
        SecurityApiDependencies securityApiDependencies = new SecurityApiDependencies(adminDns, configurationRepository, evaluator, new RestApiPrivilegesEvaluator(settings, adminDns, evaluator, principalExtractor, configPath, threadPool), new RestApiAdminPrivilegesEvaluator(threadPool.getThreadContext(), evaluator, adminDns, settings.getAsBoolean("plugins.security.restapi.admin.enabled", Boolean.valueOf(false))), auditLog, settings);
        return List.of(new RestHandler[]{new InternalUsersApiAction(clusterService, threadPool, userService, securityApiDependencies), new RolesMappingApiAction(clusterService, threadPool, securityApiDependencies), new RolesApiAction(clusterService, threadPool, securityApiDependencies), new ActionGroupsApiAction(clusterService, threadPool, securityApiDependencies), new FlushCacheApiAction(clusterService, threadPool, securityApiDependencies), new SecurityConfigApiAction(clusterService, threadPool, securityApiDependencies), new PermissionsInfoAction(settings, configPath, controller, client, adminDns, configurationRepository, clusterService, principalExtractor, evaluator, threadPool, auditLog), new AuthTokenProcessorAction(clusterService, threadPool, securityApiDependencies), new TenantsApiAction(clusterService, threadPool, securityApiDependencies), new MigrateApiAction(clusterService, threadPool, securityApiDependencies), new ValidateApiAction(clusterService, threadPool, securityApiDependencies), new AccountApiAction(clusterService, threadPool, securityApiDependencies), new NodesDnApiAction(clusterService, threadPool, securityApiDependencies), new WhitelistApiAction(clusterService, threadPool, securityApiDependencies), new AllowlistApiAction(Endpoint.ALLOWLIST, clusterService, threadPool, securityApiDependencies), new AuditApiAction(clusterService, threadPool, securityApiDependencies), new MultiTenancyConfigApiAction(clusterService, threadPool, securityApiDependencies), new SecuritySSLCertsApiAction(clusterService, threadPool, securityKeyStore, certificatesReloadEnabled, securityApiDependencies), new ConfigUpgradeApiAction(clusterService, threadPool, securityApiDependencies)});
    }
}

